/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.sync.resourcestore;

import com.microsoft.tfs.util.Check;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceStore<T> {
    private final Map<IResource, List<IResource>> memberMap = new HashMap<IResource, List<IResource>>();
    private final Map<IResource, T> operationMap = new HashMap<IResource, T>();

    public IResource[] members(IResource resource) {
        Check.notNull((Object)resource, (String)"resource");
        List<IResource> members = this.memberMap.get(resource);
        if (members == null) {
            return new IResource[0];
        }
        return members.toArray(new IResource[members.size()]);
    }

    public T getOperation(IResource resource) {
        return this.operationMap.get(resource);
    }

    public boolean addOperation(IResource resource, T operation) {
        Check.notNull((Object)resource, (String)"resource");
        Check.notNull(operation, (String)"operation");
        T oldOperation = this.operationMap.get(resource);
        if (oldOperation != null && oldOperation.equals(operation)) {
            return false;
        }
        this.operationMap.put(resource, operation);
        this.addToParent(resource);
        return true;
    }

    private void addToParent(IResource resource) {
        IContainer parent = resource.getParent();
        if (parent == null) {
            return;
        }
        List<IResource> members = this.memberMap.get(parent);
        if (members == null) {
            members = new ArrayList<IResource>();
            this.memberMap.put((IResource)parent, members);
        }
        if (!members.contains(resource)) {
            members.add(resource);
        }
        this.addToParent((IResource)parent);
    }

    public boolean contains(IResource resource) {
        return this.operationMap.containsKey(resource);
    }

    public List<IResource> removeOperation(IResource resource) {
        List<IResource> members;
        IContainer parent;
        ArrayList<IResource> removedResources = new ArrayList<IResource>();
        List<IResource> children = this.memberMap.remove(resource);
        if (children != null) {
            Iterator<IResource> i = children.iterator();
            while (i.hasNext()) {
                removedResources.addAll(this.removeOperation(i.next()));
            }
        }
        if ((parent = resource.getParent()) != null && !(parent instanceof IWorkspaceRoot) && (members = this.memberMap.get(parent)) != null) {
            members.remove(resource);
            if (members.isEmpty()) {
                removedResources.addAll(this.removeOperation((IResource)parent));
            }
        }
        this.operationMap.remove(resource);
        removedResources.add(resource);
        return removedResources;
    }
}

