/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.sync.syncinfo;

import com.microsoft.tfs.client.common.commands.vc.DownloadPendingChangeBaselineToTempLocationCommand;
import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.eclipse.Messages;
import com.microsoft.tfs.client.eclipse.TFSEclipseClientPlugin;
import com.microsoft.tfs.client.eclipse.project.ProjectRepositoryStatus;
import com.microsoft.tfs.client.eclipse.sync.SynchronizeTempFileStorage;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetOperation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Item;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;

public class BaseResourceVariant
implements IResourceVariant {
    private final TFSRepository repository;
    private final IResource resource;
    private final PendingChange localChange;
    private final Item remoteItem;
    private final GetOperation remoteOperation;

    public BaseResourceVariant(TFSRepository repository, IResource resource, PendingChange localChange, Item remoteItem, GetOperation remoteOperation) {
        Check.notNull((Object)repository, (String)"repository");
        Check.notNull((Object)resource, (String)"resource");
        this.repository = repository;
        this.resource = resource;
        this.localChange = localChange;
        this.remoteItem = remoteItem;
        this.remoteOperation = remoteOperation;
    }

    public TFSRepository getRepository() {
        return this.repository;
    }

    public byte[] asBytes() {
        return null;
    }

    public String getContentIdentifier() {
        if (this.localChange != null) {
            return String.valueOf(this.localChange.getVersion());
        }
        if (this.remoteOperation != null) {
            return String.valueOf(this.remoteOperation.getVersionLocal());
        }
        return Messages.getString("BaseResourceVariant.ContentIdentifierBase");
    }

    public String getName() {
        return this.resource.getName();
    }

    public IStorage getStorage(IProgressMonitor monitor) throws TeamException {
        IStatus status;
        if (this.localChange == null) {
            return new SynchronizeTempFileStorage(this.resource.getLocation().toOSString());
        }
        if (TFSEclipseClientPlugin.getDefault().getProjectManager().getProjectStatus(this.resource.getProject()) != ProjectRepositoryStatus.ONLINE) {
            throw new TeamException((IStatus)new Status(4, "com.microsoft.tfs.client.eclipse", 0, Messages.getString("BaseResourceVariant.NotCurrentlyConnectedReturnOnlineToViewSyncInfo"), null));
        }
        ChangeType changes = this.localChange.getChangeType();
        if (changes.contains(ChangeType.ADD)) {
            return null;
        }
        DownloadPendingChangeBaselineToTempLocationCommand command = new DownloadPendingChangeBaselineToTempLocationCommand(this.repository, this.localChange);
        try {
            status = command.run(monitor);
        }
        catch (Exception e) {
            throw new TeamException(MessageFormat.format(Messages.getString("BaseResourceVariant.CouldNotGetStorageForBaseVersionOfResourceFormat"), this.resource.getName().toString()), (Throwable)e);
        }
        if (monitor.isCanceled() || status != null && status.getSeverity() == 8) {
            throw new OperationCanceledException();
        }
        if (status == null || !status.isOK()) {
            throw new TeamException(MessageFormat.format(Messages.getString("BaseResourceVariant.CouldNotGetStorageForBaseVersionOfResourceFormat"), this.resource.getName().toString()), status != null ? status.getException() : null);
        }
        return new SynchronizeTempFileStorage(command.getTempFile());
    }

    public boolean isContainer() {
        return this.resource.getType() != 1;
    }
}

