/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.sync.syncinfo;

import com.microsoft.tfs.client.common.commands.vc.GetDownloadURLToTempLocationCommand;
import com.microsoft.tfs.client.common.commands.vc.GetVersionedItemToTempLocationCommand;
import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.eclipse.Messages;
import com.microsoft.tfs.client.eclipse.TFSEclipseClientPlugin;
import com.microsoft.tfs.client.eclipse.project.ProjectRepositoryStatus;
import com.microsoft.tfs.client.eclipse.sync.SynchronizeTempFileStorage;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetOperation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Item;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.LatestVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;

public class LatestResourceVariant
implements IResourceVariant {
    private final TFSRepository repository;
    private final IResource resource;
    private final PendingChange pendingChange;
    private final Item remoteItem;
    private final GetOperation operation;

    public LatestResourceVariant(TFSRepository repository, IResource resource, PendingChange pendingChange, Item remoteItem, GetOperation operation) {
        Check.notNull((Object)repository, (String)"repository");
        Check.notNull((Object)resource, (String)"resource");
        this.repository = repository;
        this.resource = resource;
        this.pendingChange = pendingChange;
        this.remoteItem = remoteItem;
        this.operation = operation;
    }

    public TFSRepository getRepository() {
        return this.repository;
    }

    public byte[] asBytes() {
        return null;
    }

    public String getContentIdentifier() {
        if (this.operation != null) {
            return String.valueOf(this.operation.getVersionServer());
        }
        if (this.remoteItem != null && this.remoteItem.getChangeSetID() > 0) {
            return String.valueOf(this.remoteItem.getChangeSetID());
        }
        if (this.pendingChange != null && this.pendingChange.getVersion() > 0) {
            return String.valueOf(this.pendingChange.getVersion());
        }
        return Messages.getString("LatestResourceVariant.ContentIdentifierLatest");
    }

    public String getName() {
        return this.resource.getName();
    }

    private boolean isEffectiveDelete() {
        String source;
        if (this.operation == null) {
            return this.pendingChange != null && this.pendingChange.getChangeType().contains(ChangeType.DELETE) && this.remoteItem != null && this.remoteItem.getDeletionID() > 0;
        }
        if (this.operation.isDelete()) {
            return true;
        }
        return this.operation.getCurrentLocalItem() != null && this.operation.getTargetLocalItem() != null && !this.operation.getCurrentLocalItem().equals(this.operation.getTargetLocalItem()) && (source = this.operation.getCurrentLocalItem()).equals(this.resource.getLocation().toOSString());
    }

    public IStorage getStorage(IProgressMonitor monitor) throws TeamException {
        IStatus status;
        String serverPath;
        GetDownloadURLToTempLocationCommand getCommand;
        if (TFSEclipseClientPlugin.getDefault().getProjectManager().getProjectStatus(this.resource.getProject()) != ProjectRepositoryStatus.ONLINE) {
            throw new TeamException((IStatus)new Status(4, "com.microsoft.tfs.client.eclipse", 0, Messages.getString("LatestResourceVariant.NotCurrentlyConnectedReturnOnlineToViewSyncInfo"), null));
        }
        if (this.isEffectiveDelete()) {
            return null;
        }
        if (this.operation != null && !this.operation.hasConflict()) {
            getCommand = new GetDownloadURLToTempLocationCommand(this.repository, this.operation.getDownloadURL(), this.resource.getName());
        } else if (this.operation != null) {
            serverPath = this.repository.getWorkspace().getMappedServerPath(this.resource.getLocation().toOSString());
            getCommand = new GetVersionedItemToTempLocationCommand(this.repository, serverPath, (VersionSpec)LatestVersionSpec.INSTANCE);
        } else if (this.remoteItem != null && this.remoteItem.getDownloadURL() != null) {
            getCommand = new GetDownloadURLToTempLocationCommand(this.repository, this.remoteItem.getDownloadURL());
        } else {
            serverPath = this.repository.getWorkspace().getMappedServerPath(this.resource.getLocation().toOSString());
            if (this.pendingChange != null && this.pendingChange.getVersion() == 0) {
                return null;
            }
            if (this.pendingChange != null && this.pendingChange.isRename() && ServerPath.equals((String)serverPath, (String)this.pendingChange.getServerItem())) {
                return null;
            }
            getCommand = new GetVersionedItemToTempLocationCommand(this.repository, serverPath, (VersionSpec)LatestVersionSpec.INSTANCE);
        }
        try {
            status = getCommand.run(monitor);
        }
        catch (Exception e) {
            throw new TeamException(MessageFormat.format(Messages.getString("LatestResourceVariant.CouldNotGetStorageForLatestVersionOfResourceFormat"), this.resource.getName().toString()), (Throwable)e);
        }
        if (monitor.isCanceled() || status != null && status.getSeverity() == 8) {
            throw new OperationCanceledException();
        }
        if (status == null || !status.isOK()) {
            throw new TeamException(MessageFormat.format(Messages.getString("LatestResourceVariant.CouldNotGetStorageForLatestVersionOfResourceFormat"), this.resource.getName().toString()), status != null ? status.getException() : null);
        }
        String tempFilename = getCommand.getTempLocation();
        return new SynchronizeTempFileStorage(tempFilename);
    }

    public boolean isContainer() {
        return this.resource.getType() != 1;
    }

    public GetOperation getOperation() {
        return this.operation;
    }
}

