/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.sync.syncinfo;

import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.eclipse.TFSEclipseClientPlugin;
import com.microsoft.tfs.client.eclipse.sync.LocalResourceData;
import com.microsoft.tfs.client.eclipse.sync.SynchronizeComparator;
import com.microsoft.tfs.client.eclipse.sync.syncinfo.BaseResourceVariant;
import com.microsoft.tfs.client.eclipse.sync.syncinfo.LatestResourceVariant;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ServerPathFormatException;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetOperation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Item;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.util.Check;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;

public class SynchronizeInfo
extends SyncInfo {
    private final TFSRepository repository;
    private final IResource local;
    private final PendingChange localChanges;
    private final Item remoteItem;
    private final GetOperation remoteOperation;

    public SynchronizeInfo(TFSRepository repository, IResource local, LocalResourceData localData, GetOperation remoteOperation, SynchronizeComparator comparator) {
        super(local, SynchronizeInfo.createBaseVariant(repository, local, localData, remoteOperation), SynchronizeInfo.createLatestVariant(repository, local, localData, remoteOperation), (IResourceVariantComparator)comparator);
        PendingChange pendingChange = localData != null ? localData.getPendingChange() : null;
        Item remoteItem = localData != null ? localData.getItem() : null;
        this.repository = repository;
        this.local = local;
        this.localChanges = pendingChange;
        this.remoteItem = remoteItem;
        this.remoteOperation = remoteOperation;
    }

    private static IResourceVariant createBaseVariant(TFSRepository repository, IResource local, LocalResourceData localData, GetOperation operation) {
        PendingChange pendingChange = localData != null ? localData.getPendingChange() : null;
        Item remoteItem = localData != null ? localData.getItem() : null;
        return new BaseResourceVariant(repository, local, pendingChange, remoteItem, operation);
    }

    private static IResourceVariant createLatestVariant(TFSRepository repository, IResource local, LocalResourceData localData, GetOperation operation) {
        Check.notNull((Object)local, (String)"local");
        PendingChange pendingChange = localData != null ? localData.getPendingChange() : null;
        Item remoteItem = localData != null ? localData.getItem() : null;
        return new LatestResourceVariant(repository, local, pendingChange, remoteItem, operation);
    }

    public TFSRepository getRepository() {
        return this.repository;
    }

    public PendingChange getLocalChanges() {
        return this.localChanges;
    }

    public Item getRemoteItem() {
        return this.remoteItem;
    }

    public GetOperation getRemoteOperation() {
        return this.remoteOperation;
    }

    protected int calculateKind() throws TeamException {
        int description = 0;
        boolean localExists = this.local.exists();
        String localPath = LocalPath.canonicalize((String)this.local.getLocation().toOSString());
        description = this.localChanges == null && this.remoteOperation == null ? 0 : (this.localChanges != null && this.remoteOperation == null ? 4 : (this.localChanges == null && this.remoteOperation != null ? 8 : 12));
        if (this.localChanges != null) {
            ChangeType changeTypes = this.localChanges.getChangeType();
            if (changeTypes.contains(ChangeType.ADD) || changeTypes.contains(ChangeType.BRANCH) || changeTypes.contains(ChangeType.MERGE) || changeTypes.contains(ChangeType.UNDELETE)) {
                description |= 1;
            } else if (changeTypes.contains(ChangeType.DELETE)) {
                description |= 2;
                if (this.remoteItem != null && this.localChanges.getVersion() < this.remoteItem.getChangeSetID()) {
                    description |= 0xC;
                }
            } else if (changeTypes.contains(ChangeType.RENAME)) {
                String source = null;
                String dest = null;
                try {
                    if (this.localChanges.getSourceServerItem() != null) {
                        source = this.repository.getWorkspace().getMappedLocalPath(this.localChanges.getSourceServerItem());
                    }
                    if (this.localChanges.getServerItem() != null) {
                        dest = this.repository.getWorkspace().getMappedLocalPath(this.localChanges.getServerItem());
                    }
                }
                catch (ServerPathFormatException e) {
                    // empty catch block
                }
                description = source != null && source.equalsIgnoreCase(localPath) ? (description |= 2) : (dest != null && dest.equalsIgnoreCase(localPath) ? (description |= 1) : (description |= 3));
            } else {
                description |= 3;
            }
        }
        if (this.remoteOperation != null) {
            if (this.remoteOperation.isDelete()) {
                description |= 2;
                if (this.local.getType() == 1 && !this.local.isReadOnly()) {
                    description |= 0xC;
                }
            } else if (localExists && !TFSEclipseClientPlugin.getDefault().getResourceDataManager().hasResourceData(this.local)) {
                description |= 0xD;
            } else if (localExists && this.local.getType() == 1 && !this.local.isReadOnly()) {
                description |= 0xF;
            } else if (!localExists) {
                description |= 1;
            } else if (this.remoteOperation.getCurrentLocalItem() != null && this.remoteOperation.getTargetLocalItem() != null && !this.remoteOperation.getCurrentLocalItem().equals(this.remoteOperation.getTargetLocalItem())) {
                description |= 2;
                if (this.local.getType() == 1 && !this.local.isReadOnly()) {
                    description |= 0xC;
                }
            } else {
                description |= 3;
            }
        }
        return description;
    }
}

