/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.tpignore;

import com.microsoft.tfs.client.eclipse.tpignore.TPIgnoreCacheEntry;
import com.microsoft.tfs.client.eclipse.tpignore.TPIgnoreFileParser;
import com.microsoft.tfs.client.eclipse.tpignore.TPIgnorePatternComparator;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TPIgnoreCache {
    private static final Log log = LogFactory.getLog(TPIgnoreCache.class);
    private final HashMap<IFile, TPIgnoreCacheEntry> ignoreFileToEntriesMap = new HashMap();
    private static Pattern[] NO_MATCH_PATTERN_ARRAY = new Pattern[0];

    public static IFile getIgnoreFile(IResource resource) {
        Check.notNull((Object)resource, (String)"resource");
        if (resource.getProject() == null) {
            return null;
        }
        return resource.getProject().getFile(".tpignore");
    }

    public static String createIgnorePatternForResource(IResource resource) {
        Check.notNull((Object)resource, (String)"resource");
        String path = TPIgnoreCache.createResourceMatchString(resource);
        String patternString = Pattern.quote(path);
        if (resource.getType() == 2 || resource.getType() == 4) {
            patternString = patternString + ".*";
        }
        return patternString;
    }

    public static String createResourceMatchString(IResource resource) {
        String matchPath = resource.getProjectRelativePath().toString();
        if (!matchPath.startsWith("/")) {
            matchPath = "/" + matchPath;
        }
        if (!(resource.getType() != 2 && resource.getType() != 4 || matchPath.endsWith("/"))) {
            matchPath = matchPath + "/";
        }
        return matchPath;
    }

    public static String[] getPatternStrings(Collection<Pattern> patterns) {
        Check.notNull(patterns, (String)"patterns");
        String[] ret = new String[patterns.size()];
        int i = 0;
        for (Pattern pattern : patterns) {
            ret[i++] = pattern.toString();
        }
        return ret;
    }

    public Pattern[] getMatchingPatterns(IResource resource) {
        Check.notNull((Object)resource, (String)"resource");
        if (this.canMatch(resource)) {
            Pattern[] patterns = this.getExclusionPatterns(resource.getProject());
            if (patterns == null || patterns.length == 0) {
                return NO_MATCH_PATTERN_ARRAY;
            }
            String matchPath = TPIgnoreCache.createResourceMatchString(resource);
            TreeSet<Pattern> matches = new TreeSet<Pattern>(new TPIgnorePatternComparator());
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(matchPath).matches()) continue;
                log.debug((Object)MessageFormat.format("item ''{0}'' matched exclusion pattern ''{1}''", matchPath, pattern.toString()));
                matches.add(pattern);
            }
            if (matches.size() > 0) {
                return matches.toArray(new Pattern[matches.size()]);
            }
        }
        return NO_MATCH_PATTERN_ARRAY;
    }

    public boolean matchesAnyPattern(IResource resource) {
        Check.notNull((Object)resource, (String)"resource");
        if (this.canMatch(resource)) {
            Pattern[] patterns = this.getExclusionPatterns(resource.getProject());
            if (patterns == null || patterns.length == 0) {
                return false;
            }
            String matchPath = TPIgnoreCache.createResourceMatchString(resource);
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(matchPath).matches()) continue;
                log.debug((Object)MessageFormat.format("item ''{0}'' matched exclusion pattern ''{1}''", matchPath, pattern.toString()));
                return true;
            }
        }
        return false;
    }

    private boolean canMatch(IResource resource) {
        return resource.getType() == 1 || resource.getType() == 2 || resource.getType() == 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pattern[] getExclusionPatterns(IProject project) {
        Check.notNull((Object)project, (String)"project");
        IFile ignoreFile = TPIgnoreCache.getIgnoreFile((IResource)project);
        if (ignoreFile == null) {
            return null;
        }
        boolean ignoreFileExists = ignoreFile.exists();
        long ignoreFileLastModified = ignoreFile.getModificationStamp();
        Pattern[] ret = null;
        HashMap<IFile, TPIgnoreCacheEntry> hashMap = this.ignoreFileToEntriesMap;
        synchronized (hashMap) {
            boolean alreadyHaveEntry = this.ignoreFileToEntriesMap.containsKey(ignoreFile);
            TPIgnoreCacheEntry existingEntry = null;
            int refreshAction = 1;
            if (ignoreFileExists && alreadyHaveEntry) {
                existingEntry = this.ignoreFileToEntriesMap.get(ignoreFile);
                refreshAction = existingEntry.getLoadedFromDiskTime() != ignoreFileLastModified ? 2 : 4;
            } else if (ignoreFileExists && !alreadyHaveEntry) {
                refreshAction = 2;
            } else if (!ignoreFileExists && alreadyHaveEntry) {
                refreshAction = 3;
            }
            switch (refreshAction) {
                case 2: {
                    log.trace((Object)"LOAD_OR_REFRESH");
                    ret = TPIgnoreFileParser.load(ignoreFile);
                    if (ret == null) {
                        this.ignoreFileToEntriesMap.remove(ignoreFile);
                        break;
                    }
                    this.ignoreFileToEntriesMap.put(ignoreFile, new TPIgnoreCacheEntry(ignoreFile.getModificationStamp(), ret));
                    break;
                }
                case 3: {
                    log.trace((Object)"REMOVE_EXISTING");
                    this.ignoreFileToEntriesMap.remove(ignoreFile);
                    break;
                }
                case 4: {
                    log.trace((Object)"RETURN_EXISTING");
                    Check.notNull((Object)existingEntry, (String)"existingEntry");
                    ret = existingEntry.getPatterns();
                    break;
                }
                case 1: {
                    log.trace((Object)"NOTHING");
                }
            }
        }
        return ret;
    }

    private static class RefreshAction {
        public static final int NOTHING = 1;
        public static final int LOAD_OR_REFRESH = 2;
        public static final int REMOVE_EXISTING = 3;
        public static final int RETURN_EXISTING = 4;

        private RefreshAction() {
        }
    }
}

