/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.tpignore;

import com.microsoft.tfs.client.eclipse.tpignore.Line;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.NewlineUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TPIgnoreDocument {
    private static final Log log = LogFactory.getLog(TPIgnoreDocument.class);
    public static final String DEFAULT_FILENAME = ".tpignore";
    private final List<Line> lines = new ArrayList<Line>();
    private final String newlineSequence;
    private final String charsetName;

    public TPIgnoreDocument(String newlineSequence, String charsetName) {
        Check.notNull((Object)newlineSequence, (String)"newlineSequence");
        this.newlineSequence = newlineSequence;
        this.charsetName = charsetName;
    }

    public synchronized List<Line> getLines() {
        return new ArrayList<Line>(this.lines);
    }

    public synchronized void addLine(Line line) {
        Check.notNull((Object)line, (String)"line");
        this.lines.add(line);
    }

    public synchronized void setLine(int index, Line line) {
        Check.notNull((Object)line, (String)"line");
        this.lines.set(index, line);
    }

    public synchronized void setLines(List<Line> lines) {
        this.lines.clear();
        this.lines.addAll(lines);
    }

    public synchronized Line getLine(int index) {
        return this.lines.get(index);
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        for (Line line : this.lines) {
            sb.append(line.getContents());
            sb.append(this.newlineSequence);
        }
        return sb.toString();
    }

    public InputStream getInputStream() {
        String contents = this.toString();
        try {
            return new ByteArrayInputStream(this.charsetName != null ? contents.getBytes(this.charsetName) : contents.getBytes(ResourcesPlugin.getEncoding()));
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)MessageFormat.format("Could not use original encoding {0} when preparing stream; using default instead", this.charsetName), (Throwable)e);
            return new ByteArrayInputStream(contents.getBytes());
        }
    }

    public void write(IFile file, IProgressMonitor progressMonitor) throws CoreException {
        Check.notNull((Object)file, (String)"file");
        if (!file.exists()) {
            file.create(this.getInputStream(), false, progressMonitor);
        } else {
            file.setContents(this.getInputStream(), false, true, progressMonitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TPIgnoreDocument read(IFile file) throws IOException, CoreException {
        Check.notNull((Object)file, (String)"file");
        if (!file.exists()) {
            return new TPIgnoreDocument(NewlineUtils.PLATFORM_NEWLINE, null);
        }
        String newline = null;
        Reader reader = null;
        try {
            reader = new InputStreamReader(file.getContents(), file.getCharset());
            newline = NewlineUtils.detectNewlineConvention((Reader)reader);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
                reader = null;
            }
        }
        if (newline == null) {
            newline = NewlineUtils.PLATFORM_NEWLINE;
        }
        TPIgnoreDocument ret = new TPIgnoreDocument(newline, file.getCharset());
        BufferedReader br = null;
        try {
            String line;
            reader = new InputStreamReader(file.getContents(), file.getCharset());
            br = new BufferedReader(reader);
            while ((line = br.readLine()) != null) {
                ret.addLine(new Line(line));
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
        return ret;
    }
}

