/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.tpignore;

import com.microsoft.tfs.client.eclipse.Messages;
import com.microsoft.tfs.client.eclipse.TFSEclipseClientPlugin;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.FileHelpers;
import com.microsoft.tfs.util.LocaleUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

final class TPIgnoreFileParser {
    private static final Log log = LogFactory.getLog(TPIgnoreFileParser.class);
    public static final char COMMENT_CHAR = '#';
    private static int compileFlags = -1000;

    TPIgnoreFileParser() {
    }

    private static synchronized int getCompileFlags() {
        if (compileFlags == -1000) {
            compileFlags = FileHelpers.doesFileSystemIgnoreCase() ? 66 : 0;
        }
        return compileFlags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pattern[] load(IFile ignoreFile) {
        Check.notNull((Object)ignoreFile, (String)"file");
        if (!ignoreFile.exists()) {
            return null;
        }
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(ignoreFile.getContents(), ignoreFile.getCharset() != null ? ignoreFile.getCharset() : ResourcesPlugin.getEncoding()));
            String line = null;
            int lineNumber = 0;
            while ((line = reader.readLine()) != null) {
                ++lineNumber;
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                try {
                    patterns.add(Pattern.compile(line, TPIgnoreFileParser.getCompileFlags()));
                }
                catch (PatternSyntaxException e) {
                    log.warn((Object)MessageFormat.format(Messages.getString("TPIgnoreFileParser.CouldNotParseIgnorePatternFormat", LocaleUtil.ROOT), line, ignoreFile.getLocation().toOSString(), Integer.toString(lineNumber)), (Throwable)e);
                    TFSEclipseClientPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.microsoft.tfs.client.eclipse", 0, MessageFormat.format(Messages.getString("TPIgnoreFileParser.CouldNotParseIgnorePatternFormat"), line, ignoreFile.getLocation().toOSString(), Integer.toString(lineNumber)), (Throwable)e));
                }
            }
        }
        catch (CoreException e) {
            log.error((Object)MessageFormat.format("Resource error reading resource exclusion file {0}", ignoreFile), (Throwable)e);
            Pattern[] patternArray = null;
            return patternArray;
        }
        catch (IOException e) {
            log.error((Object)MessageFormat.format("Error reading resource exclusion file {0}", ignoreFile), (Throwable)e);
            Pattern[] patternArray = null;
            return patternArray;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return patterns.toArray(new Pattern[patterns.size()]);
    }
}

