/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.util;

import com.microsoft.tfs.client.eclipse.resource.PluginResourceFilters;
import com.microsoft.tfs.util.Check;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.team.core.RepositoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TeamUtils {
    public static final QualifiedName PROVIDER_PROP_KEY = new QualifiedName("org.eclipse.team.core", "repository");

    private TeamUtils() {
    }

    public static IProject[] getProjectsConfiguredWith(String providerId) {
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> configuredProjects = new ArrayList<IProject>();
        for (int i = 0; i < allProjects.length; ++i) {
            if (!TeamUtils.isConfiguredWith((IResource)allProjects[i], providerId)) continue;
            configuredProjects.add(allProjects[i]);
        }
        return configuredProjects.toArray(new IProject[configuredProjects.size()]);
    }

    public static boolean isConfigured(IResource resource) {
        Check.notNull((Object)resource, (String)"resource");
        if (8 == resource.getType()) {
            return false;
        }
        return RepositoryProvider.isShared((IProject)resource.getProject());
    }

    public static boolean isConfiguredWith(IResource resource, String providerId) {
        return TeamUtils.getRepositoryProvider(resource, providerId, false) != null;
    }

    public static boolean isConfiguredWithOtherProvider(IResource resource, String providerId) {
        return TeamUtils.isConfigured(resource) && TeamUtils.getRepositoryProvider(resource, providerId, false) == null;
    }

    public static RepositoryProvider getRepositoryProvider(IResource resource, String providerId) {
        return TeamUtils.getRepositoryProvider(resource, providerId, true);
    }

    public static RepositoryProvider getRepositoryProvider(IResource resource, String providerId, boolean mustExist) {
        Check.notNull((Object)resource, (String)"resource");
        Check.notNull((Object)providerId, (String)"providerId");
        if (8 == resource.getType()) {
            if (mustExist) {
                throw new IllegalArgumentException("it is illegal to call getRepositoryProvider() with the root resource when mustExist is true");
            }
            return null;
        }
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resource.getProject(), (String)providerId);
        if (mustExist && provider == null) {
            throw new UnexpectedProjectConfigurationException(resource, providerId);
        }
        return provider;
    }

    public static RepositoryProvider getRepositoryProvider(IResource resource) {
        return TeamUtils.getRepositoryProvider(resource, true);
    }

    public static RepositoryProvider getRepositoryProvider(IResource resource, boolean mustExist) {
        Check.notNull((Object)resource, (String)"resource");
        if (8 == resource.getType()) {
            if (mustExist) {
                throw new IllegalArgumentException("it is illegal to call getRepositoryProvider() with the root resource when mustExist is true");
            }
            return null;
        }
        RepositoryProvider repositoryProvider = RepositoryProvider.getProvider((IProject)resource.getProject());
        if (mustExist && repositoryProvider == null) {
            throw new UnexpectedProjectConfigurationException(resource, null);
        }
        return repositoryProvider;
    }

    public static List<IFolder> markBaselineFoldersTeamPrivate(IResource resource) throws CoreException {
        Check.notNull((Object)resource, (String)"resource");
        final ArrayList<IFolder> baselines = new ArrayList<IFolder>();
        resource.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (PluginResourceFilters.LOCAL_WORKSPACE_BASELINE_FILTER.filter(resource).isReject()) {
                    baselines.add((IFolder)resource);
                    resource.setTeamPrivateMember(true);
                    return false;
                }
                return true;
            }
        }, 2, true);
        return baselines;
    }

    public static class UnexpectedProjectConfigurationException
    extends RuntimeException {
        private final IResource resource;
        private final String message;

        public UnexpectedProjectConfigurationException(IResource resource, String expectedProviderId) {
            Check.notNull((Object)resource, (String)"resource");
            this.resource = resource;
            RepositoryProvider provider = TeamUtils.getRepositoryProvider(resource, false);
            StringBuffer buffer = new StringBuffer();
            buffer.append("Unexpected configuration for project [");
            buffer.append(resource.getProject().getName());
            buffer.append("]: ");
            if (expectedProviderId != null) {
                buffer.append("expected provider was [");
                buffer.append(expectedProviderId);
                buffer.append("] ");
                if (provider != null) {
                    buffer.append("but actual provider was [");
                    buffer.append(provider.getID());
                    buffer.append("]");
                } else {
                    buffer.append("but project does not have a provider");
                }
            } else if (provider != null) {
                buffer.append("provider is [" + provider.getID() + "]");
            } else {
                buffer.append("project has no provider");
            }
            this.message = buffer.toString();
        }

        public String getMessage() {
            return this.message;
        }

        public IResource getResource() {
            return this.resource;
        }
    }
}

