/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.workspace;

import com.microsoft.tfs.core.TFSConnection;
import com.microsoft.tfs.core.clients.versioncontrol.Workstation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.WorkspaceInfo;
import com.microsoft.tfs.core.config.persistence.DefaultPersistenceStoreProvider;
import com.microsoft.tfs.core.config.persistence.PersistenceStoreProvider;
import com.microsoft.tfs.util.Check;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class WorkspaceManager {
    private final Object lock = new Object();
    private final Map connectionMap = new HashMap();
    private final Map workspaceMap = new HashMap();
    private final Map projectMap = new HashMap();
    private Workspace defaultWorkspace = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWorkspaces(TFSConnection connection, Workspace[] workspaces) {
        Check.notNull((Object)connection, (String)"connection");
        Check.notNull((Object)workspaces, (String)"workspaces");
        Object object = this.lock;
        synchronized (object) {
            if (this.connectionMap.containsKey(connection)) {
                this.connectionMap.remove(connection);
            }
            this.connectionMap.put(connection, workspaces);
            for (int i = 0; i < workspaces.length; ++i) {
                this.workspaceMap.put(workspaces[i], new ArrayList());
            }
            if (this.defaultWorkspace == null && workspaces.length > 0) {
                this.defaultWorkspace = workspaces[0];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Workspace getDefaultWorkspace() {
        Object object = this.lock;
        synchronized (object) {
            return this.defaultWorkspace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Workspace[] getWorkspaces() {
        Object object = this.lock;
        synchronized (object) {
            Set workspaceSet = this.workspaceMap.keySet();
            return workspaceSet.toArray(new Workspace[workspaceSet.size()]);
        }
    }

    public Workspace getWorkspace(WorkspaceInfo workspace) {
        Check.notNull((Object)workspace, (String)"workspace");
        return this.getWorkspace(workspace.getServerURI(), workspace.getName(), workspace.getComputer(), workspace.getOwnerName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Workspace getWorkspace(URI serverUri, String name, String computer, String owner) {
        Check.notNull((Object)serverUri, (String)"serverUri");
        Check.notNull((Object)name, (String)"name");
        Check.notNull((Object)computer, (String)"computer");
        Check.notNull((Object)owner, (String)"owner");
        Object object = this.lock;
        synchronized (object) {
            for (Workspace workspace : this.workspaceMap.keySet()) {
                if (!serverUri.equals(workspace.getServerURI()) || !name.equals(workspace.getName()) || !computer.equals(workspace.getComputer()) || !owner.equals(workspace.getOwnerName())) continue;
                return workspace;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Workspace getWorkspace(IProject project) {
        Check.notNull((Object)project, (String)"project");
        Object object = this.lock;
        synchronized (object) {
            if (this.projectMap.containsKey(project)) {
                return (Workspace)this.projectMap.get(project);
            }
            WorkspaceInfo cachedWorkspace = Workstation.getCurrent((PersistenceStoreProvider)DefaultPersistenceStoreProvider.INSTANCE).getLocalWorkspaceInfo(project.getLocation().toOSString());
            if (cachedWorkspace != null) {
                return this.getWorkspace(cachedWorkspace);
            }
            return null;
        }
    }

    public Workspace getWorkspace(IResource resource) {
        Check.notNull((Object)resource, (String)"resource");
        return this.getWorkspace(resource.getProject());
    }
}

