/*
 * Decompiled with CFR 0.152.
 */
package r;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Scanner;
import jline.TerminalFactory;
import jline.console.ConsoleReader;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.netlib.blas.BLAS;
import org.netlib.lapack.LAPACK;
import r.Option;
import r.RContext;
import r.Utils;
import r.data.RAny;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.ast.AssignVariable;
import r.nodes.ast.Loop;
import r.nodes.tools.PrettyPrinter;
import r.nodes.tools.TreeViewer;
import r.parser.RLexer;
import r.parser.RParser;

public class Console {
    public static boolean DEBUG = Utils.getProperty("RConsole.debug", false);
    public static boolean DEBUG_GUI = Utils.getProperty("RConsole.debug.gui", false);
    public static String prompt = Utils.getProperty("RConsole.prompt", "> ");
    public static String promptMore = Utils.getProperty("RConsole.promptmore", "+ ");
    public static String[] trailingArgs;
    public static String[] commandArgs;
    public static long startTime;
    static String inputFile;
    static boolean interactive;
    static boolean forceVisible;
    static boolean debuggingFormat;
    static Option[] options;

    public static void storeCommandLineArguments(String[] args) {
        int alen = args.length;
        commandArgs = new String[alen + 1];
        Console.commandArgs[0] = "FAST-R";
        System.arraycopy(args, 0, commandArgs, 1, alen);
        int argsIndex = -1;
        for (int i = 0; i < alen - 1; ++i) {
            if (!"--args".equals(args[i])) continue;
            argsIndex = i;
            break;
        }
        if (argsIndex == -1) {
            trailingArgs = new String[0];
        } else {
            int tlen = alen - argsIndex - 1;
            trailingArgs = new String[tlen];
            System.arraycopy(args, argsIndex + 1, trailingArgs, 0, tlen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        long before;
        block13: {
            Console.storeCommandLineArguments(args);
            startTime = System.nanoTime();
            try {
                Option.processCommandLine(args, options);
            }
            catch (Exception e1) {
                return;
            }
            before = System.nanoTime();
            try {
                RContext.debuggingFormat(debuggingFormat);
                if (interactive || inputFile == null) {
                    System.err.println("Using LAPACK: " + LAPACK.getInstance().getClass().getName());
                    System.err.println("Using BLAS: " + BLAS.getInstance().getClass().getName());
                    System.err.println("Using GNUR: " + (RContext.hasGNUR() ? "yes" : "not available"));
                    if (inputFile == null) {
                        try {
                            ConsoleReader console = new ConsoleReader();
                            console.setPrompt("> ");
                            Console.interactive(Console.createReader(console));
                            break block13;
                        }
                        finally {
                            try {
                                TerminalFactory.get().restore();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    Console.interactive(Console.createReader(new BufferedReader(new FileReader(inputFile))));
                    break block13;
                }
                Console.processFile(Console.openANTLRStream(inputFile));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        long after = System.nanoTime();
        long elapsed = after - before;
        System.err.println("\n" + (inputFile == null ? "(stdin)" : inputFile) + ": Elapsed " + elapsed / 1000000L + " microseconds");
    }

    private static RLineReader createReader(final BufferedReader buf) {
        return new RLineReader(){

            @Override
            public String readLine() throws IOException {
                return buf.readLine();
            }

            @Override
            public void prompt(String s) {
                System.out.print(s);
            }
        };
    }

    private static RLineReader createReader(final ConsoleReader console) {
        return new RLineReader(){

            @Override
            public String readLine() throws IOException {
                return console.readLine();
            }

            @Override
            public void prompt(String s) {
                console.setPrompt(s);
            }
        };
    }

    static void interactive(RLineReader in) throws IOException {
        RLexer lexer = new RLexer();
        RParser parser = new RParser(null);
        StringBuilder incomplete = new StringBuilder();
        while (true) {
            try {
                while (true) {
                    in.prompt(incomplete.length() == 0 ? prompt : promptMore);
                    System.out.flush();
                    ASTNode tree = Console.parseStatement(in.readLine(), lexer, parser, incomplete);
                    parser.reset();
                    if (tree == null) continue;
                    if (DEBUG) {
                        Console.debug(tree);
                    }
                    Console.printResult(tree, RContext.eval(tree));
                }
            }
            catch (RecognitionException e) {
                if (e.getUnexpectedType() != -1) {
                    Console.parseError(parser, e);
                    incomplete.setLength(0);
                    continue;
                }
                incomplete.append('\n');
                continue;
            }
            catch (IllegalArgumentException e) {
                RecognitionException re = (RecognitionException)e.getCause();
                if (re.getUnexpectedType() != -1) {
                    Console.lexerError(lexer, re);
                    incomplete.setLength(0);
                    continue;
                }
                incomplete.append('\n');
                continue;
            }
            catch (IOException e) {
                throw e;
            }
            catch (RError e) {
                if (!debuggingFormat) continue;
                e.printStackTrace();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    static void processFile(ANTLRStringStream inputStream) {
        ASTNode tree = RContext.parseFile(inputStream);
        if (tree != null) {
            Console.printResult(tree, RContext.eval(tree));
        }
    }

    static ASTNode parseStatement(String line, RLexer lexer, RParser parser, StringBuilder incomplete) throws IOException, RecognitionException {
        if (line == null) {
            throw new EOFException();
        }
        incomplete.append(line);
        lexer.resetIncomplete();
        lexer.setCharStream((CharStream)new ANTLRStringStream(incomplete.toString()));
        parser.setTokenStream((TokenStream)new CommonTokenStream((TokenSource)lexer));
        ASTNode result = parser.interactive();
        incomplete.setLength(0);
        return result;
    }

    static ANTLRStringStream openANTLRStream(String fName) throws IOException {
        return fName.equals("-") ? new ANTLRInputStream(System.in) : new ANTLRFileStream(fName);
    }

    static void debug(ASTNode tree) {
        if (DEBUG_GUI) {
            TreeViewer.showTree(tree);
        } else {
            new PrettyPrinter(System.err).print(tree);
        }
    }

    static void parseError(RParser parser, RecognitionException e) {
        Token token = e.token;
        String[] tokenNames = parser.getTokenNames();
        System.err.print("Parse error on '" + token.getText() + "' at " + token.getLine() + ":" + (token.getCharPositionInLine() + 1) + (token.getType() > 0 ? " (" + tokenNames[token.getType()] + "): " : ": "));
        System.err.println(parser.getErrorMessage(e, tokenNames) + ".");
    }

    static void lexerError(RLexer lexer, RecognitionException e) {
        String[] tokenNames = lexer.getTokenNames();
        System.err.println("Parse error (lexer): " + lexer.getErrorMessage(e, tokenNames) + ".");
    }

    static void printResult(ASTNode expr, RAny result) {
        if (forceVisible || !(expr instanceof AssignVariable) && !(expr instanceof Loop)) {
            Console.println(result.pretty());
        }
    }

    public static void println(String str) {
        System.out.println(str);
    }

    static {
        options = new Option[]{new Option.Text("FastR -- Another Fast R Implementation"), new Option("-f", "Script input file", 1){

            @Override
            protected void processOption(String name, String[] opts) {
                inputFile = opts[0];
            }
        }, new Option("--interactive", "Force interactive even if -f is provided"){

            @Override
            protected void processOption(String name, String[] opts) throws IOException {
                interactive = true;
            }
        }, new Option("--debugging-format", "Use debugging output format"){

            @Override
            protected void processOption(String name, String[] opts) throws IOException {
                debuggingFormat = true;
            }
        }, new Option("--visible", "Skip invisibility checks"){

            @Override
            protected void processOption(String name, String[] opts) throws IOException {
                forceVisible = true;
            }
        }, new Option("--waitForKey", "Wait for 'ENTER' before starting execution"){

            @Override
            protected void processOption(String name, String[] opts) {
                System.out.println("Press ENTER to start...");
                new Scanner(System.in).nextLine();
            }
        }, new Option("--debug", "debug in 'text' or 'gui' mode", 1){

            @Override
            protected void processOption(String name, String[] opts) {
                DEBUG = true;
                if (opts[0].equalsIgnoreCase("gui")) {
                    DEBUG_GUI = true;
                }
            }
        }, new Option.Help(){

            @Override
            protected void processOption(String name, String[] opts) {
                Option.Help.displayHelp(System.out, options, 0);
            }
        }};
    }

    static interface RLineReader {
        public String readLine() throws IOException;

        public void prompt(String var1);
    }
}

