/*
 * Decompiled with CFR 0.152.
 */
package r;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import r.RContext;
import r.Utils;
import r.data.RAny;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RRaw;
import r.data.RString;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;

public class Convert {
    static final Pattern numberSplit = Pattern.compile("^[+-]?[^e+-]+(?:e[+-]?[\\d]+)?");
    public static final ConversionStatus globalConversionStatus = new ConversionStatus();
    static final String[] rawStrings = Convert.generateRawStrings();

    public static RComplex.Complex string2complex(String v) {
        return Convert.string2complex(v, null);
    }

    public static RComplex.Complex string2complex(String v, ConversionStatus warn) {
        String input;
        Matcher m;
        if (v != RString.NA && (m = numberSplit.matcher(input = v.trim())).find()) {
            int realEnd = m.end();
            String sreal = input.substring(m.start(), realEnd);
            double real = Convert.string2double(sreal, warn);
            double imag = 0.0;
            int imagEnd = input.length();
            if (realEnd != imagEnd) {
                if (input.charAt(imagEnd - 1) == 'i') {
                    String simag = input.substring(realEnd, imagEnd - 1);
                    imag = Convert.string2double(simag, warn);
                } else {
                    if (warn != null) {
                        warn.naIntroduced = true;
                    }
                    return RComplex.Complex.NA;
                }
            }
            return new RComplex.Complex(real, imag);
        }
        if (warn != null) {
            warn.naIntroduced = true;
        }
        return RComplex.Complex.NA;
    }

    public static double string2double(String v) {
        return Convert.string2double(v, null);
    }

    public static double string2double(String v, ConversionStatus warn) {
        block8: {
            if (v != RString.NA) {
                try {
                    return Double.parseDouble(v);
                }
                catch (NumberFormatException e) {
                    if (v.equals("Inf") || v.equals("+Inf")) {
                        return Double.POSITIVE_INFINITY;
                    }
                    if (v.equals("-Inf")) {
                        return Double.NEGATIVE_INFINITY;
                    }
                    if (v.startsWith("0x")) {
                        try {
                            return Convert.int2double(Integer.decode(v));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (warn == null) break block8;
                    warn.naIntroduced = true;
                }
            }
        }
        return RDouble.NA;
    }

    public static String double2string(double d) {
        if (!RDouble.RDoubleUtils.isNA(d)) {
            if (!RContext.debuggingFormat() && RDouble.RDoubleUtils.fitsRInt(d) && (double)((int)d) == d) {
                return Convert.int2string((int)d);
            }
            return Double.toString(d);
        }
        return RString.NA;
    }

    public static int string2int(String s) {
        return Convert.string2int(s, null);
    }

    public static int string2int(String s, ConversionStatus warn) {
        block3: {
            if (s != RString.NA) {
                try {
                    return Integer.decode(s);
                }
                catch (NumberFormatException e) {
                    if (warn == null) break block3;
                    warn.naIntroduced = true;
                }
            }
        }
        return Integer.MIN_VALUE;
    }

    public static String int2string(int i) {
        if (i == Integer.MIN_VALUE) {
            return RString.NA;
        }
        if (!RContext.debuggingFormat()) {
            return Integer.toString(i);
        }
        return Integer.toString(i) + "L";
    }

    public static int string2logical(String s) {
        return Convert.string2logical(s, null);
    }

    public static int string2logical(String s, ConversionStatus warn) {
        if (s != RString.NA) {
            if (s.equals("TRUE") || s.equals("T")) {
                return 1;
            }
            if (s.equals("FALSE") || s.equals("F")) {
                return 0;
            }
            if (s.equals("True") || s.equals("true")) {
                return 1;
            }
            if (s.equals("False") || s.equals("false")) {
                return 0;
            }
            if (warn != null) {
                warn.naIntroduced = true;
            }
        }
        return Integer.MIN_VALUE;
    }

    public static String logical2string(int i) {
        switch (i) {
            case 0: {
                return "FALSE";
            }
            case -2147483648: {
                return RString.NA;
            }
        }
        return "TRUE";
    }

    public static byte string2raw(String s) {
        return Convert.string2raw(s, null);
    }

    public static byte string2raw(String s, ConversionStatus warn) {
        if (s != RString.NA) {
            int intVal;
            String str;
            int len = s.length();
            if (len > 0 && s.charAt(0) == '0') {
                int nzeros;
                for (nzeros = 1; nzeros < len && s.charAt(nzeros) == '0'; ++nzeros) {
                }
                str = s.substring(nzeros);
            } else {
                str = s;
            }
            try {
                intVal = Integer.decode(str);
            }
            catch (NumberFormatException e) {
                if (warn != null) {
                    warn.naIntroduced = true;
                }
                return 0;
            }
            if (intVal >= 0 && intVal <= 255) {
                return (byte)intVal;
            }
        }
        if (warn != null) {
            warn.outOfRange = true;
        }
        return 0;
    }

    public static String raw2string(byte v) {
        return rawStrings[Convert.byteToUnsigned(v)];
    }

    public static String complex2string(double real, double imag) {
        if (!RComplex.RComplexUtils.eitherIsNA(real, imag)) {
            String sgn = imag >= 0.0 || Double.isNaN(imag) ? "+" : "";
            return Convert.double2string(real) + sgn + Convert.double2string(imag) + "i";
        }
        return RString.NA;
    }

    public static double complex2double(double real, double imag) {
        return Convert.complex2double(real, imag, null);
    }

    public static double complex2double(double real, double imag, ConversionStatus warn) {
        if (!RComplex.RComplexUtils.eitherIsNAorNaN(real, imag)) {
            if (imag != 0.0 && warn != null) {
                warn.imagDiscarded = true;
            }
            return real;
        }
        return RDouble.NA;
    }

    public static int complex2int(double real, double imag) {
        return Convert.complex2int(real, imag, null);
    }

    public static int complex2int(double real, double imag, ConversionStatus warn) {
        if (!RComplex.RComplexUtils.eitherIsNAorNaN(real, imag)) {
            if (RDouble.RDoubleUtils.fitsRInt(real)) {
                if (imag != 0.0 && warn != null) {
                    warn.imagDiscarded = true;
                }
                return (int)real;
            }
            if (warn != null) {
                warn.naIntroduced = true;
            }
        }
        return Integer.MIN_VALUE;
    }

    public static int complex2logical(double real, double imag) {
        if (!RComplex.RComplexUtils.eitherIsNAorNaN(real, imag)) {
            boolean v = real != 0.0 || imag != 0.0;
            return v ? 1 : 0;
        }
        return Integer.MIN_VALUE;
    }

    public static byte complex2raw(double real, double imag) {
        return Convert.complex2raw(real, imag, null);
    }

    public static byte complex2raw(double real, double imag, ConversionStatus warn) {
        if (!RComplex.RComplexUtils.eitherIsNAorNaN(real, imag)) {
            if (real >= 0.0 && real < 256.0) {
                if (imag != 0.0 && warn != null) {
                    warn.imagDiscarded = true;
                }
                return (byte)real;
            }
            if (!RDouble.RDoubleUtils.fitsRInt(real)) {
                if (warn != null) {
                    warn.naIntroduced = true;
                }
                return 0;
            }
            if (imag != 0.0 && warn != null) {
                warn.imagDiscarded = true;
            }
        }
        if (warn != null) {
            warn.outOfRange = true;
        }
        return 0;
    }

    public static int double2int(double d) {
        return Convert.double2int(d, null);
    }

    public static int double2int(double d, ConversionStatus warn) {
        if (!RDouble.RDoubleUtils.isNAorNaN(d)) {
            if (RDouble.RDoubleUtils.fitsRInt(d)) {
                return (int)d;
            }
            if (warn != null) {
                warn.naIntroduced = true;
            }
        }
        return Integer.MIN_VALUE;
    }

    public static double int2double(int i) {
        return i == Integer.MIN_VALUE ? RDouble.NA : (double)i;
    }

    public static int double2logical(double d) {
        if (RDouble.RDoubleUtils.isNAorNaN(d)) {
            return Integer.MIN_VALUE;
        }
        return d != 0.0 ? 1 : 0;
    }

    public static double logical2double(int l) {
        return l == Integer.MIN_VALUE ? RDouble.NA : (double)l;
    }

    public static byte double2raw(double d) {
        return Convert.double2raw(d, null);
    }

    public static byte double2raw(double d, ConversionStatus warn) {
        if (!RDouble.RDoubleUtils.isNAorNaN(d)) {
            if (d >= 0.0 && d < 256.0) {
                return (byte)d;
            }
            if (!RDouble.RDoubleUtils.fitsRInt(d)) {
                if (warn != null) {
                    warn.naIntroduced = true;
                }
                return 0;
            }
        }
        if (warn != null) {
            warn.outOfRange = true;
        }
        return 0;
    }

    public static double raw2double(byte v) {
        return Convert.byteToUnsigned(v);
    }

    public static int int2logical(int i) {
        if (i == Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return i != 0 ? 1 : 0;
    }

    public static int logical2int(int l) {
        return l;
    }

    public static byte int2raw(int v) {
        return Convert.int2raw(v, null);
    }

    public static byte int2raw(int v, ConversionStatus warn) {
        if (v >= 0 && v < 256) {
            return (byte)v;
        }
        if (warn != null) {
            warn.outOfRange = true;
        }
        return 0;
    }

    public static int raw2int(byte v) {
        return Convert.byteToUnsigned(v);
    }

    public static byte logical2raw(int v) {
        return Convert.logical2raw(v, null);
    }

    public static byte logical2raw(int v, ConversionStatus warn) {
        if (v != Integer.MIN_VALUE) {
            return (byte)v;
        }
        if (warn != null) {
            warn.outOfRange = true;
        }
        return 0;
    }

    public static int raw2logical(byte v) {
        return Convert.byteToUnsigned(v) != 0 ? 1 : 0;
    }

    public static String prettyNA(String s) {
        if (s != RString.NA) {
            return s;
        }
        return "NA";
    }

    public static String prettyGTNALT(String s) {
        if (s != RString.NA) {
            return s;
        }
        return "<NA>";
    }

    public static void prettyGTNALT(String[] s) {
        for (int i = 0; i < s.length; ++i) {
            if (s[i] != RString.NA) continue;
            s[i] = "<NA>";
        }
    }

    public static RString coerceToStringError(RAny arg, ASTNode ast) {
        Convert.globalConversionStatus.naIntroduced = false;
        RString res = arg.asString(globalConversionStatus);
        if (!Convert.globalConversionStatus.naIntroduced) {
            return res;
        }
        throw RError.getCannotCoerce(ast, arg.typeOf(), "character");
    }

    public static RString coerceToStringWarning(RAny arg, ASTNode ast) {
        Convert.globalConversionStatus.naIntroduced = false;
        RString res = arg.asString(globalConversionStatus);
        if (!Convert.globalConversionStatus.naIntroduced) {
            return res;
        }
        RContext.warning(ast, "NAs introduced by coercion");
        return res;
    }

    public static RComplex coerceToComplexWarning(RAny arg, ASTNode ast) {
        Convert.globalConversionStatus.naIntroduced = false;
        RComplex res = arg.asComplex(globalConversionStatus);
        if (!Convert.globalConversionStatus.naIntroduced) {
            return res;
        }
        RContext.warning(ast, "NAs introduced by coercion");
        return res;
    }

    public static RDouble coerceToDoubleWarning(RAny arg, ASTNode ast) {
        Convert.globalConversionStatus.naIntroduced = false;
        RDouble res = arg.asDouble(globalConversionStatus);
        if (!Convert.globalConversionStatus.naIntroduced) {
            return res;
        }
        RContext.warning(ast, "NAs introduced by coercion");
        return res;
    }

    public static RDouble coerceToDoubleError(RAny arg, ASTNode ast) {
        Convert.globalConversionStatus.naIntroduced = false;
        RDouble res = arg.asDouble(globalConversionStatus);
        if (!Convert.globalConversionStatus.naIntroduced) {
            return res;
        }
        throw RError.getCannotCoerce(ast, arg.typeOf(), "double");
    }

    public static RInt coerceToIntWarning(RAny arg, ASTNode ast) {
        Convert.globalConversionStatus.naIntroduced = false;
        RInt res = arg.asInt(globalConversionStatus);
        if (!Convert.globalConversionStatus.naIntroduced) {
            return res;
        }
        RContext.warning(ast, "NAs introduced by coercion");
        return res;
    }

    public static RRaw coerceToRawWarning(RAny arg, ASTNode ast) {
        Convert.globalConversionStatus.naIntroduced = false;
        Convert.globalConversionStatus.outOfRange = false;
        RRaw res = arg.asRaw(globalConversionStatus);
        if (!Convert.globalConversionStatus.naIntroduced) {
            if (Convert.globalConversionStatus.outOfRange) {
                RContext.warning(ast, "out-of-range values treated as 0 in coercion to raw");
            }
        } else {
            RContext.warning(ast, "NAs introduced by coercion");
            RContext.warning(ast, "out-of-range values treated as 0 in coercion to raw");
        }
        return res;
    }

    public static boolean checkFirstLogical(RAny arg, int value) {
        RLogical l = arg.asLogical();
        if (l.size() == 0) {
            return false;
        }
        return l.getLogical(0) == value;
    }

    public static int scalar2int(RAny v) {
        if (v instanceof RInt) {
            return ((RInt)v).getInt(0);
        }
        if (v instanceof RDouble) {
            return Convert.double2int(((RDouble)v).getDouble(0));
        }
        if (v instanceof RLogical) {
            return Convert.logical2int(((RLogical)v).getLogical(0));
        }
        Utils.nyi("unsupported type");
        return -1;
    }

    public static double scalar2double(RAny v) {
        if (v instanceof RInt) {
            return Convert.double2int(((RInt)v).getInt(0));
        }
        if (v instanceof RDouble) {
            return ((RDouble)v).getDouble(0);
        }
        if (v instanceof RLogical) {
            return Convert.logical2double(((RLogical)v).getLogical(0));
        }
        Utils.nyi("unsupported type");
        return -1.0;
    }

    public static String[] symbols2strings(RSymbol[] symbols) {
        int size = symbols.length;
        String[] res = new String[size];
        for (int i = 0; i < size; ++i) {
            res[i] = symbols[i].name();
        }
        return res;
    }

    public static String[] generateRawStrings() {
        String[] res = new String[256];
        for (int i = 0; i < 256; ++i) {
            res[i] = Integer.toHexString(i / 16) + Integer.toHexString(i % 16);
        }
        return res;
    }

    public static int byteToUnsigned(byte v) {
        return v & 0xFF;
    }

    public static class ConversionStatus {
        public boolean naIntroduced;
        public boolean outOfRange;
        public boolean imagDiscarded;
    }
}

