/*
 * Decompiled with CFR 0.152.
 */
package r;

import java.util.Arrays;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import r.Console;
import r.Utils;
import r.data.RAny;
import r.data.RFunction;
import r.data.internal.Connection;
import r.errors.ManageError;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.BaseR;
import r.nodes.exec.RNode;
import r.nodes.tools.BuildExecutableTree;
import r.parser.RLexer;
import r.parser.RParser;
import r.runtime.Frame;

public class RContext {
    public static final boolean DEBUG = Utils.getProperty("RConsole.debug.gui", false);
    private static boolean debuggingFormat = false;
    private static ManageError errorManager = new ManageError(System.err);
    private static BuildExecutableTree executableTreeBuilder = new BuildExecutableTree();
    private static final int NCONNECTIONS = 128;
    private static final Connection[] connections = new Connection[128];
    private static int hasGNUR;

    public static boolean debuggingFormat() {
        return debuggingFormat;
    }

    public static boolean debuggingFormat(boolean useDebuggingFormat) {
        boolean previous = debuggingFormat;
        debuggingFormat = useDebuggingFormat;
        return previous;
    }

    public static RAny eval(ASTNode expr, boolean useDebuggingFormat) {
        RContext.debuggingFormat(useDebuggingFormat);
        return RContext.eval(expr);
    }

    public static RAny eval(ASTNode expr) {
        try {
            return (RAny)executableTreeBuilder.createLazyRootTree(expr).execute(null);
        }
        catch (RError e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            RContext.error(e);
            throw new Error("Never reached");
        }
    }

    public static RNode createNode(ASTNode expr) {
        return executableTreeBuilder.createTree(expr);
    }

    public static RNode createRootNode(ASTNode expr, final RFunction rootEnclosingFunction) {
        return new BaseR(expr){
            @RNode.Child
            RNode node;
            {
                super(x0);
                this.node = this.adoptChild(executableTreeBuilder.createTree(this.ast, rootEnclosingFunction));
            }

            @Override
            public Object execute(Frame frame) {
                return this.node.execute(frame);
            }

            @Override
            protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
                assert (oldNode != null);
                if (this.node == oldNode) {
                    this.node = newNode;
                    return this.adoptInternal(newNode);
                }
                return super.replaceChild(oldNode, newNode);
            }
        };
    }

    public static void warning(ASTNode expr, String msg, Object ... args) {
        errorManager.warning(expr, String.format(msg, args));
    }

    public static void warning(ASTNode expr, String msg) {
        errorManager.warning(expr, msg);
    }

    public static void warning(RError err) {
        errorManager.warning(err);
    }

    public static void error(ASTNode expr, String msg) {
        errorManager.error(expr, msg);
    }

    public static void error(RError err) {
        errorManager.error(err);
    }

    public static int allocateConnection(Connection connection) {
        for (int i = 0; i < 128; ++i) {
            if (connections[i] != null) continue;
            RContext.connections[i] = connection;
            return i;
        }
        return -1;
    }

    public static void freeConnection(int i) {
        assert (Utils.check(connections[i] != null));
        RContext.connections[i] = null;
    }

    public static Connection getConnection(int i) {
        return i >= 0 && i < 128 ? connections[i] : null;
    }

    public static boolean hasGNUR() {
        if (hasGNUR == -1) {
            try {
                System.loadLibrary("gnurglue");
                hasGNUR = 1;
            }
            catch (Throwable t) {
                hasGNUR = 0;
            }
        }
        return hasGNUR == 1;
    }

    public static ASTNode parseFile(ANTLRStringStream inputStream) {
        CommonTokenStream tokens = new CommonTokenStream();
        RLexer lexer = new RLexer((CharStream)inputStream);
        tokens.setTokenSource((TokenSource)lexer);
        RParser parser = new RParser((TokenStream)tokens);
        try {
            return parser.script();
        }
        catch (RecognitionException e) {
            Console.parseError(parser, e);
            return null;
        }
    }

    static {
        Arrays.fill(connections, null);
        hasGNUR = -1;
    }
}

