/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RSymbol;
import r.data.internal.ScalarComplexImpl;
import r.data.internal.ScalarDoubleImpl;
import r.data.internal.ScalarIntImpl;
import r.data.internal.View;
import r.nodes.ast.ASTNode;
import r.nodes.exec.Arithmetic;
import r.nodes.exec.BaseR;
import r.nodes.exec.RNode;
import r.runtime.Frame;
import r.runtime.SpecializationException;

public class Abs
extends CallFactory {
    static final Abs _ = new Abs("abs", new String[]{"x"}, null);

    Abs(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    public static double abs(double d) {
        return RDouble.RDoubleUtils.arithIsNA(d) ? RDouble.NA : Math.abs(d);
    }

    public static int abs(int v) {
        return v < 0 ? -v : v;
    }

    public static double abs(double real, double imag) {
        return RComplex.RComplexUtils.eitherIsNA(real, imag) ? RDouble.NA : Arithmetic.chypot(real, imag);
    }

    public static RDouble abs(RDouble orig) {
        return new View.RDoubleProxy<RDouble>(orig){

            @Override
            public double getDouble(int i) {
                return Abs.abs(((RDouble)this.orig).getDouble(i));
            }
        };
    }

    public static RInt abs(RInt orig) {
        return new View.RIntProxy<RInt>(orig){

            @Override
            public int getInt(int i) {
                return Abs.abs(((RInt)this.orig).getInt(i));
            }
        };
    }

    public static RDouble abs(RComplex orig) {
        return new View.RDoubleProxy<RComplex>(orig){

            @Override
            public double getDouble(int i) {
                return Abs.abs(((RComplex)this.orig).getReal(i), ((RComplex)this.orig).getImag(i));
            }
        };
    }

    @Override
    public RNode create(final ASTNode call, final RSymbol[] names, final RNode[] exprs) {
        this.check(call, names, exprs);
        return new Builtin.Builtin1(call, names, exprs){

            @Override
            public final RAny doBuiltIn(Frame frame, RAny arg) {
                try {
                    throw new SpecializationException((Object)null);
                }
                catch (SpecializationException e) {
                    if (arg instanceof ScalarIntImpl) {
                        this.replace(Abs.createScalarInt(call, names, exprs));
                    } else {
                        this.replace(Abs.createGeneric(call, names, exprs));
                    }
                    return Abs.generic(arg);
                }
            }
        };
    }

    public static RNode createScalarInt(final ASTNode call, final RSymbol[] names, final RNode[] exprs) {
        return new Specialized(call, exprs[0]){

            @Override
            public Object execute(Frame frame) {
                Object val = this.expr.execute(frame);
                try {
                    if (!(val instanceof ScalarIntImpl)) {
                        throw new SpecializationException((Object)null);
                    }
                    int i = ((ScalarIntImpl)val).getInt();
                    return i < 0 ? RInt.RIntFactory.getScalar(-i) : val;
                }
                catch (SpecializationException e) {
                    exprs[0].replace(this.expr);
                    this.replace(Abs.createGeneric(call, names, exprs));
                    return Abs.generic((RAny)val);
                }
            }

            @Override
            public int executeScalarInteger(Frame frame) throws SpecializationException {
                try {
                    int i = this.expr.executeScalarInteger(frame);
                    return Abs.abs(i);
                }
                catch (SpecializationException e) {
                    this.replace(Abs.createGeneric(call, names, exprs));
                    throw new SpecializationException(Abs.generic((RAny)e.getResult()));
                }
            }
        };
    }

    public static RNode createGeneric(ASTNode call, RSymbol[] names, RNode[] exprs) {
        return new Builtin.Builtin1(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny arg) {
                return Abs.generic(arg);
            }
        };
    }

    public static RAny generic(RAny arg) {
        if (arg instanceof ScalarDoubleImpl) {
            return RDouble.RDoubleFactory.getScalar(Abs.abs(((ScalarDoubleImpl)arg).getDouble()));
        }
        if (arg instanceof ScalarIntImpl) {
            return RInt.RIntFactory.getScalar(Abs.abs(((ScalarIntImpl)arg).getInt()));
        }
        if (arg instanceof ScalarComplexImpl) {
            ScalarComplexImpl c = (ScalarComplexImpl)arg;
            return RDouble.RDoubleFactory.getScalar(Abs.abs(c.getReal(), c.getImag()));
        }
        if (arg instanceof RDouble) {
            return Abs.abs((RDouble)arg);
        }
        if (arg instanceof RInt) {
            return Abs.abs((RInt)arg);
        }
        if (arg instanceof RComplex) {
            return Abs.abs((RComplex)arg);
        }
        if (arg instanceof RLogical) {
            return arg.asInt();
        }
        throw Utils.nyi();
    }

    public static abstract class Specialized
    extends BaseR {
        @RNode.Child
        RNode expr;

        public Specialized(ASTNode ast, RNode expr) {
            super(ast);
            this.expr = this.adoptChild(expr);
        }

        @Override
        public Object execute(Frame frame) {
            return null;
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            if (this.expr == oldNode) {
                this.expr = newNode;
                return this.adoptInternal(newNode);
            }
            return super.replaceChild(oldNode, newNode);
        }
    }
}

