/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.RContext;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RSymbol;
import r.data.internal.ComplexImpl;
import r.data.internal.DoubleImpl;
import r.data.internal.IntImpl;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;
import r.runtime.SpecializationException;

final class Aperm
extends CallFactory {
    static final CallFactory _ = new Aperm("aperm", new String[]{"a", "perm", "resize"}, new String[]{"a"});

    private Aperm(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        int posPerm = ia.position("perm");
        int posA = ia.position("a");
        int posResize = ia.position("resize");
        return new ApermImpl(call, names, exprs, posA, posPerm, posResize);
    }

    public static class Complex
    extends Generalized {
        protected Complex(Generalized other) {
            super(other);
        }

        @Override
        public RAny aperm(RArray ary, int[] perm, boolean resize) {
            try {
                if (!(ary instanceof ComplexImpl)) {
                    throw new SpecializationException((Object)null);
                }
                int arySize = ary.size();
                int[] aryDim = ary.dimensions();
                int[] resultDim = Complex.calculateResizedDimension(aryDim, perm);
                double[] source = ((ComplexImpl)ary).getContent();
                double[] dest = new double[source.length];
                int[] idx = new int[aryDim.length];
                int[] resultIdx = new int[aryDim.length];
                int[] dimMults = Complex.createDimMults(resultDim);
                for (int i = 0; i < arySize; ++i) {
                    Complex.perm(idx, resultIdx, perm);
                    int offset = Complex.offset(resultIdx, dimMults);
                    dest[offset << 1] = source[i << 1];
                    dest[(offset << 1) + 1] = source[(i << 1) + 1];
                    Complex.increment(idx, aryDim);
                }
                return RDouble.RDoubleFactory.getFor(dest, resize ? resultDim : aryDim, ary.names(), null);
            }
            catch (SpecializationException e) {
                return this.replace(new Generalized(this)).aperm(ary, perm, resize);
            }
        }
    }

    public static class Double
    extends Generalized {
        protected Double(Generalized other) {
            super(other);
        }

        @Override
        public RAny aperm(RArray ary, int[] perm, boolean resize) {
            try {
                if (!(ary instanceof DoubleImpl)) {
                    throw new SpecializationException((Object)null);
                }
                int arySize = ary.size();
                int[] aryDim = ary.dimensions();
                int[] resultDim = Double.calculateResizedDimension(aryDim, perm);
                double[] source = ((DoubleImpl)ary).getContent();
                double[] dest = new double[source.length];
                int[] idx = new int[aryDim.length];
                int[] resultIdx = new int[aryDim.length];
                int[] dimMults = Double.createDimMults(resultDim);
                for (int i = 0; i < arySize; ++i) {
                    Double.perm(idx, resultIdx, perm);
                    int offset = Double.offset(resultIdx, dimMults);
                    dest[offset] = source[i];
                    Double.increment(idx, aryDim);
                }
                return RDouble.RDoubleFactory.getFor(dest, resize ? resultDim : aryDim, ary.names(), null);
            }
            catch (SpecializationException e) {
                return this.replace(new Generalized(this)).aperm(ary, perm, resize);
            }
        }
    }

    public static class Int
    extends Generalized {
        protected Int(Generalized other) {
            super(other);
        }

        @Override
        public RAny aperm(RArray ary, int[] perm, boolean resize) {
            try {
                if (!(ary instanceof IntImpl)) {
                    throw new SpecializationException((Object)null);
                }
                int arySize = ary.size();
                int[] aryDim = ary.dimensions();
                int[] resultDim = Int.calculateResizedDimension(aryDim, perm);
                int[] source = ((IntImpl)ary).getContent();
                int[] dest = new int[source.length];
                int[] idx = new int[aryDim.length];
                int[] resultIdx = new int[aryDim.length];
                int[] dimMults = Int.createDimMults(resultDim);
                for (int i = 0; i < arySize; ++i) {
                    Int.perm(idx, resultIdx, perm);
                    int offset = Int.offset(resultIdx, dimMults);
                    dest[offset] = source[i];
                    Int.increment(idx, aryDim);
                }
                return RInt.RIntFactory.getFor(dest, resize ? resultDim : aryDim, ary.names(), null);
            }
            catch (SpecializationException e) {
                return this.replace(new Generalized(this)).aperm(ary, perm, resize);
            }
        }
    }

    public static class ApermImpl
    extends Generalized {
        public ApermImpl(ASTNode orig, RSymbol[] argNames, RNode[] argExprs, int posA, int posPerm, int posResize) {
            super(orig, argNames, argExprs, posA, posPerm, posResize);
        }

        @Override
        public RAny aperm(RArray ary, int[] perm, boolean resize) {
            try {
                throw new SpecializationException((Object)null);
            }
            catch (SpecializationException e) {
                if (ary instanceof IntImpl) {
                    return this.replace(new Int(this)).aperm(ary, perm, resize);
                }
                if (ary instanceof DoubleImpl) {
                    return this.replace(new Double(this)).aperm(ary, perm, resize);
                }
                if (ary instanceof ComplexImpl) {
                    return this.replace(new Complex(this)).aperm(ary, perm, resize);
                }
                return this.replace(new Generalized(this)).aperm(ary, perm, resize);
            }
        }
    }

    protected static class Generalized
    extends Builtin {
        final int posPerm;
        final int posA;
        final int posResize;

        public Generalized(ASTNode orig, RSymbol[] argNames, RNode[] argExprs, int posA, int posPerm, int posResize) {
            super(orig, argNames, argExprs);
            this.posA = posA;
            this.posPerm = posPerm;
            this.posResize = posResize;
        }

        protected Generalized(Generalized other) {
            this(other.ast, other.argNames, other.argExprs, other.posA, other.posPerm, other.posResize);
        }

        protected final RArray parseArray(RAny[] params) {
            RArray ary = (RArray)params[this.posA];
            if (ary.dimensions() == null) {
                throw RError.getFirstArgMustBeArray(this.ast);
            }
            return ary;
        }

        protected final int[] parsePermutation(int[] aryDim, RAny[] params) {
            int[] result = new int[aryDim.length];
            if (this.posPerm == -1) {
                for (int i = 0; i < result.length; ++i) {
                    result[i] = result.length - i - 1;
                }
                return result;
            }
            boolean[] usedIndices = new boolean[result.length];
            RArray perm = (RArray)params[this.posPerm];
            if (perm.size() != aryDim.length) {
                throw RError.getValueIsOfWrongLength(this.ast, "perm");
            }
            if (perm instanceof RComplex) {
                RContext.warning(this.ast, "imaginary parts discarded in coercion");
            }
            RInt p = perm.asInt();
            for (int i = 0; i < result.length; ++i) {
                int x = p.getInt(i);
                if (x < 1 || x > aryDim.length) {
                    throw RError.getValueOutOfRange(this.ast, "perm");
                }
                result[i] = --x;
                if (usedIndices[x]) {
                    throw RError.getInvalidArgument(this.ast, "perm");
                }
                usedIndices[x] = true;
            }
            return result;
        }

        protected final boolean parseResize(RAny[] params) {
            if (this.posResize == -1) {
                return true;
            }
            return params[this.posResize].asLogical().getLogical(0) != 0;
        }

        protected static final void perm(int[] source, int[] dest, int[] perm) {
            for (int i = 0; i < perm.length; ++i) {
                dest[i] = source[perm[i]];
            }
        }

        protected static final void increment(int[] idx, int[] dim) {
            for (int i = 0; i < idx.length; ++i) {
                int n = i;
                idx[n] = idx[n] + 1;
                if (idx[i] < dim[i]) break;
                idx[i] = 0;
            }
        }

        protected static final int offset(int[] idx, int[] mults) {
            int result = 0;
            for (int i = 0; i < idx.length; ++i) {
                result += idx[i] * mults[i];
            }
            return result;
        }

        protected static final int[] createDimMults(int[] dim) {
            int[] result = new int[dim.length];
            result[0] = 1;
            for (int i = 1; i < result.length; ++i) {
                result[i] = dim[i - 1] * result[i - 1];
            }
            return result;
        }

        protected static final int[] calculateResizedDimension(int[] aryDim, int[] perm) {
            int[] result = new int[aryDim.length];
            for (int i = 0; i < perm.length; ++i) {
                result[i] = aryDim[perm[i]];
            }
            return result;
        }

        @Override
        public final RAny doBuiltIn(Frame frame, RAny[] params) {
            RArray ary = this.parseArray(params);
            int[] aryDim = ary.dimensions();
            int[] perm = this.parsePermutation(aryDim, params);
            boolean resize = this.parseResize(params);
            return this.aperm(ary, perm, resize);
        }

        protected RAny aperm(RArray ary, int[] perm, boolean resize) {
            int arySize = ary.size();
            int[] aryDim = ary.dimensions();
            int[] resultDim = Generalized.calculateResizedDimension(aryDim, perm);
            RArray result = Utils.createArray(ary, arySize, resize ? resultDim : aryDim, ary.names(), null);
            int[] idx = new int[aryDim.length];
            int[] resultIdx = new int[aryDim.length];
            int[] dimMults = Generalized.createDimMults(resultDim);
            for (int i = 0; i < arySize; ++i) {
                Generalized.perm(idx, resultIdx, perm);
                int offset = Generalized.offset(resultIdx, dimMults);
                result.set(offset, ary.get(i));
                Generalized.increment(idx, aryDim);
            }
            return result;
        }
    }
}

