/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.ScalarLogicalImpl;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Array
extends CallFactory {
    static final CallFactory _ = new Array("array", new String[]{"data", "dim", "dimnames"}, new String[0]);

    private Array(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final boolean provData = ia.provided("data");
        final boolean provDim = ia.provided("dim");
        final boolean provDimnames = ia.provided("dimnames");
        final int posData = ia.position("data");
        final int posDim = ia.position("dim");
        final int posDimnames = ia.position("dimnames");
        return new Builtin(call, names, exprs){

            private RArray parseData(RAny source) {
                if (source instanceof RArray) {
                    return ((RArray)source).size() == 0 ? RLogical.BOXED_NA : (RArray)source;
                }
                throw RError.getDataVector(this.ast);
            }

            private DimAndSize parseDimensions(RAny dim) {
                int[] result;
                int size = 1;
                if (dim instanceof RInt) {
                    RInt d = (RInt)dim;
                    result = new int[d.size()];
                    for (int i = 0; i < result.length; ++i) {
                        int x = d.getInt(i);
                        if (x < 0) {
                            throw RError.getDimsContainNegativeValues(this.ast);
                        }
                        result[i] = x;
                        size *= x;
                    }
                } else if (dim instanceof RDouble) {
                    RDouble d = (RDouble)dim;
                    result = new int[d.size()];
                    for (int i = 0; i < result.length; ++i) {
                        if (d.isNAorNaN(i)) {
                            throw RError.getNegativeLengthVectorsNotAllowed(this.ast);
                        }
                        int x = (int)Math.floor(d.getDouble(i));
                        if (x < 0) {
                            throw RError.getDimsContainNegativeValues(this.ast);
                        }
                        result[i] = x;
                        size *= x;
                    }
                } else if (dim instanceof RLogical) {
                    RLogical d = (RLogical)dim;
                    result = new int[d.size()];
                    for (int i = 0; i < result.length; ++i) {
                        int x;
                        if (d.isNAorNaN(i)) {
                            throw RError.getNegativeLengthVectorsNotAllowed(this.ast);
                        }
                        result[i] = x = d.getLogical(i);
                        size *= x;
                    }
                } else if (dim instanceof RString) {
                    RString d = (RString)dim;
                    result = new int[d.size()];
                    for (int i = 0; i < result.length; ++i) {
                        int x;
                        if (d.isNAorNaN(i)) {
                            throw RError.getNegativeLengthVectorsNotAllowed(this.ast);
                        }
                        try {
                            x = (int)Math.floor(Double.parseDouble(d.getString(i)));
                        }
                        catch (Throwable e) {
                            throw RError.getNegativeLengthVectorsNotAllowed(this.ast);
                        }
                        result[i] = x;
                        size *= x;
                    }
                } else {
                    throw RError.getNegativeLengthVectorsNotAllowed(this.ast);
                }
                return new DimAndSize(result, size);
            }

            private String[][] parseDimnames(RAny dimnames, int[] dim) {
                throw Utils.nyi("dimnames are not yet implemented");
            }

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] params) {
                ScalarLogicalImpl source = provData ? this.parseData(params[posData]) : RLogical.BOXED_NA;
                DimAndSize dim = provDim ? this.parseDimensions(params[posDim]) : new DimAndSize(new int[]{source.size()}, source.size());
                String[][] dimnames = provDimnames ? this.parseDimnames(params[posDimnames], dim.dim) : (String[][])null;
                return this.createArrayObject(source, dim.dim, dim.size, dimnames);
            }

            protected RAny createArrayObject(RArray source, int[] dim, int size, String[][] dimnames) {
                assert (dimnames == null) : "dimnames not supported yet";
                RArray result = Utils.createArray(source, size, dim, null, null);
                int ssize = source.size();
                int si = 0;
                for (int i = 0; i < size; ++i) {
                    result.set(i, source.get(si));
                    if (++si != ssize) continue;
                    si = 0;
                }
                return result;
            }
        };
    }

    private static class DimAndSize {
        public final int[] dim;
        public final int size;

        public DimAndSize(int[] dim, int size) {
            this.dim = dim;
            this.size = size;
        }
    }
}

