/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Convert;
import r.RContext;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLanguage;
import r.data.RList;
import r.data.RLogical;
import r.data.RNull;
import r.data.RRaw;
import r.data.RString;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

abstract class AsBase
extends CallFactory {
    static final Convert.ConversionStatus warn = new Convert.ConversionStatus();

    AsBase(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    abstract RAny genericCast(ASTNode var1, RAny var2);

    abstract RAny getEmpty();

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        if (exprs.length == 0) {
            return new Builtin.Builtin0(call, names, exprs){

                @Override
                public RAny doBuiltIn(Frame frame) {
                    return AsBase.this.getEmpty();
                }
            };
        }
        this.check(call, names, exprs);
        return new Builtin.Builtin1(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny arg) {
                return AsBase.this.genericCast(this.ast, arg);
            }
        };
    }

    static RAny genericAsList(ASTNode ast, RAny arg) {
        if (arg instanceof RList) {
            return arg;
        }
        RArray res = arg.asList().stripAttributes();
        if (arg instanceof RArray) {
            return res.setNames(((RArray)arg).names());
        }
        return res;
    }

    static boolean isRecursive(RList list) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (!(list.getRAny(i) instanceof RList)) continue;
            return true;
        }
        return false;
    }

    static String deparse(RAny v, boolean quote) {
        if (v instanceof RNull) {
            return "NULL";
        }
        if (v instanceof RLanguage) {
            return v.pretty();
        }
        if (!(v instanceof RArray)) {
            throw Utils.nyi("unsupported type");
        }
        RArray a = (RArray)v;
        int size = a.size();
        if (size == 0) {
            return v.pretty();
        }
        if (size == 1) {
            if (!quote || !(a instanceof RString)) {
                return v.pretty();
            }
            return "\\\"" + ((RString)a).getString(0) + "\\\"";
        }
        if (v instanceof RInt) {
            int from;
            RInt ival = (RInt)v;
            int last = from = ival.getInt(0);
            boolean isSequence = true;
            for (int i = 1; i < size; ++i) {
                int n = ival.getInt(i);
                if (n - 1 != last) {
                    isSequence = false;
                    break;
                }
                last = n;
            }
            if (isSequence) {
                return Integer.toString(from) + ":" + Integer.toString(last);
            }
        }
        StringBuilder str = new StringBuilder();
        str.append("c(");
        for (int i = 0; i < size; ++i) {
            RAny e;
            if (i > 0) {
                str.append(", ");
            }
            if (!((e = ((RArray)v).boxedGet(i)) instanceof RString)) {
                str.append(e.pretty());
                continue;
            }
            str.append("\\\"");
            str.append(((RString)e).getString(0));
            str.append("\\\"");
        }
        str.append(")");
        return str.toString();
    }

    static void listAsString(ASTNode ast, StringBuilder str, RList list, boolean isRecursive) {
        int size = list.size();
        if (!isRecursive) {
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    str.append(", ");
                }
                RAny e = list.getRAny(i);
                str.append(AsBase.deparse(e, true));
            }
        } else {
            str.append("list(");
            for (int i = 0; i < size; ++i) {
                RAny e;
                if (i > 0) {
                    str.append(", ");
                }
                if ((e = list.getRAny(i)) instanceof RList) {
                    RList child = (RList)e;
                    AsBase.listAsString(ast, str, child, AsBase.isRecursive(child));
                    continue;
                }
                str.append(AsBase.deparse(e, true));
            }
            str.append(")");
        }
    }

    static RString genericAsString(ASTNode ast, RAny arg) {
        if (!(arg instanceof RList)) {
            return (RString)arg.asString().stripAttributes();
        }
        RList list = (RList)arg;
        if (!AsBase.isRecursive(list)) {
            int size = list.size();
            String[] content = new String[size];
            for (int i = 0; i < size; ++i) {
                RAny e = list.getRAny(i);
                content[i] = AsBase.deparse(e, false);
            }
            return RString.RStringFactory.getFor(content);
        }
        StringBuilder str = new StringBuilder();
        AsBase.listAsString(ast, str, list, true);
        return RString.RStringFactory.getScalar(str.toString());
    }

    static RAny genericAsComplex(ASTNode ast, RAny arg) {
        if (!(arg instanceof RList)) {
            return Convert.coerceToComplexWarning(arg, ast).stripAttributes();
        }
        AsBase.warn.naIntroduced = false;
        RList l = (RList)arg;
        double[] content = new double[2 * l.size()];
        for (int i = 0; i < l.size(); ++i) {
            RArray a = (RArray)l.getRAny(i);
            if (a.size() == 1) {
                if (a instanceof RList) {
                    content[2 * i] = RDouble.NA;
                    content[2 * i + 1] = RDouble.NA;
                    continue;
                }
                RComplex ca = a.asComplex(warn);
                content[2 * i] = ca.getReal(0);
                content[2 * i + 1] = ca.getImag(0);
                continue;
            }
            if (a.size() > 1) {
                throw RError.getListCoercion(ast, "complex");
            }
            content[i] = RDouble.NA;
        }
        if (AsBase.warn.naIntroduced) {
            RContext.warning(ast, "NAs introduced by coercion");
        }
        return RComplex.RComplexFactory.getFor(content);
    }

    static RAny genericAsDouble(ASTNode ast, RAny arg) {
        if (!(arg instanceof RList)) {
            return Convert.coerceToDoubleWarning(arg, ast).stripAttributes();
        }
        AsBase.warn.naIntroduced = false;
        RList l = (RList)arg;
        double[] content = new double[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            RArray a = (RArray)l.getRAny(i);
            if (a.size() == 1) {
                content[i] = a instanceof RList ? RDouble.NA : a.asDouble(warn).getDouble(0);
                continue;
            }
            if (a.size() > 1) {
                throw RError.getListCoercion(ast, "numeric");
            }
            content[i] = RDouble.NA;
        }
        if (AsBase.warn.naIntroduced) {
            RContext.warning(ast, "NAs introduced by coercion");
        }
        return RDouble.RDoubleFactory.getFor(content);
    }

    static RAny genericAsInt(ASTNode ast, RAny arg) {
        if (!(arg instanceof RList)) {
            return Convert.coerceToIntWarning(arg, ast).stripAttributes();
        }
        AsBase.warn.naIntroduced = false;
        RList l = (RList)arg;
        int[] content = new int[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            RArray a = (RArray)l.getRAny(i);
            if (a.size() == 1) {
                content[i] = a instanceof RList ? Integer.MIN_VALUE : a.asInt(warn).getInt(0);
                continue;
            }
            if (a.size() > 1) {
                throw RError.getListCoercion(ast, "integer");
            }
            content[i] = Integer.MIN_VALUE;
        }
        if (AsBase.warn.naIntroduced) {
            RContext.warning(ast, "NAs introduced by coercion");
        }
        return RInt.RIntFactory.getFor(content);
    }

    static RAny genericAsLogical(ASTNode ast, RAny arg) {
        if (!(arg instanceof RList)) {
            return arg.asLogical().stripAttributes();
        }
        RList l = (RList)arg;
        int[] content = new int[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            RArray a = (RArray)l.getRAny(i);
            if (a.size() == 1) {
                content[i] = a instanceof RList ? Integer.MIN_VALUE : a.asLogical().getLogical(0);
                continue;
            }
            if (a.size() > 1) {
                throw RError.getListCoercion(ast, "logical");
            }
            content[i] = Integer.MIN_VALUE;
        }
        return RLogical.RLogicalFactory.getFor(content);
    }

    static RAny genericAsRaw(ASTNode ast, RAny arg) {
        if (!(arg instanceof RList)) {
            return Convert.coerceToRawWarning(arg, ast).stripAttributes();
        }
        AsBase.warn.outOfRange = false;
        AsBase.warn.naIntroduced = false;
        RList l = (RList)arg;
        byte[] content = new byte[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            RArray a = (RArray)l.getRAny(i);
            if (a.size() == 1) {
                if (a instanceof RList) {
                    content[i] = 0;
                    AsBase.warn.outOfRange = true;
                    continue;
                }
                content[i] = a.asRaw(warn).getRaw(0);
                continue;
            }
            if (a.size() > 1) {
                throw RError.getListCoercion(ast, "raw");
            }
            content[i] = 0;
            AsBase.warn.outOfRange = true;
        }
        if (AsBase.warn.naIntroduced) {
            RContext.warning(ast, "NAs introduced by coercion");
        }
        if (AsBase.warn.naIntroduced) {
            RContext.warning(ast, "NAs introduced by coercion");
            RContext.warning(ast, "out-of-range values treated as 0 in coercion to raw");
        } else if (AsBase.warn.outOfRange) {
            RContext.warning(ast, "out-of-range values treated as 0 in coercion to raw");
        }
        return RRaw.RRawFactory.getFor(content);
    }

    static RAny genericAsVector(ASTNode ast, RAny arg0, RAny arg1) {
        if (!(arg1 instanceof RString)) {
            throw RError.getInvalidMode(ast);
        }
        RString ms = (RString)arg1;
        if (ms.size() != 1) {
            throw RError.getInvalidMode(ast);
        }
        String mode = ms.getString(0);
        if (mode.equals("any")) {
            return arg0 instanceof RList ? arg0 : arg0.stripAttributes();
        }
        if (mode.equals("integer")) {
            return AsBase.genericAsInt(ast, arg0);
        }
        if (mode.equals("numeric") || mode.equals("double")) {
            return AsBase.genericAsDouble(ast, arg0);
        }
        if (mode.equals("logical")) {
            return AsBase.genericAsLogical(ast, arg0);
        }
        if (mode.equals("list")) {
            return AsBase.genericAsList(ast, arg0);
        }
        if (mode.equals("character")) {
            return AsBase.genericAsString(ast, arg0);
        }
        if (mode.equals("raw")) {
            return AsBase.genericAsRaw(ast, arg0);
        }
        throw Utils.nyi("unsupported mode");
    }
}

