/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class AsMatrix
extends CallFactory {
    static final CallFactory _ = new AsMatrix("as.matrix", new String[]{"x", "..."}, new String[]{"x"});

    private AsMatrix(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int xPosition = ia.position("x");
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                return AsMatrix.asMatrix(args[xPosition], this.ast);
            }
        };
    }

    public static RArray asMatrix(RAny x, ASTNode ast) {
        if (!(x instanceof RArray)) {
            throw RError.getInvalidArgument(ast, "x");
        }
        return AsMatrix.asMatrix((RArray)x);
    }

    public static RArray asMatrix(RArray a) {
        int[] dim = a.dimensions();
        if (dim != null && dim.length == 2) {
            return a;
        }
        return AsMatrix.castToMatrix(a);
    }

    public static RArray castToMatrix(RArray a) {
        int size = a.size();
        int[] ndims = new int[]{size, 1};
        RArray na = !a.isTemporary() ? Utils.copyArray(a) : a;
        return na.setAttributes(null).setDimensions(ndims);
    }
}

