/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.builtins.EnvBase;
import r.data.RAny;
import r.data.REnvironment;
import r.data.RSymbol;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Assign
extends CallFactory {
    static final CallFactory _ = new Assign("assign", new String[]{"x", "value", "pos", "envir", "inherits", "immediate"}, new String[]{"x", "value"});
    private static final boolean DEFAULT_INHERITS = false;

    private Assign(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int posX = ia.position("x");
        final int posValue = ia.position("value");
        final int posEnvir = ia.position("envir");
        final int posInherits = ia.position("inherits");
        final int posPos = ia.position("pos");
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                RSymbol nm = EnvBase.parseX(args[posX], this.ast);
                RAny value = args[posValue];
                RAny envirArg = posEnvir != -1 ? args[posEnvir] : null;
                RAny posArg = posPos != -1 ? args[posPos] : null;
                REnvironment envir = EnvBase.extractEnvironment(envirArg, posArg, frame, this.ast);
                boolean inherits = posInherits != -1 ? EnvBase.parseInherits(args[posInherits], this.ast) : false;
                envir.assign(nm, value, inherits, this.ast);
                return value;
            }
        };
    }
}

