/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import java.util.LinkedHashMap;
import java.util.Map;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.builtins.DimensionsBase;
import r.builtins.Names;
import r.data.RAny;
import r.data.RLogical;
import r.data.RNull;
import r.data.RString;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Attr
extends CallFactory {
    static final CallFactory _ = new Attr("attr", new String[]{"x", "which", "exact"}, new String[]{"x", "which"});
    private static final int PARTIAL_MAP_THRESHOLD = 256;

    private Attr(String name, String[] parameters, String[] required) {
        super(name, parameters, required);
    }

    static RSymbol parseWhich(RAny arg, ASTNode ast) {
        if (!(arg instanceof RString)) {
            throw RError.getMustBeCharacter(ast, "which");
        }
        RString astr = (RString)arg;
        if (astr.size() != 1) {
            throw RError.getExactlyOneWhich(ast);
        }
        return RSymbol.getSymbol(astr.getString(0));
    }

    private static boolean parseExact(RAny arg) {
        RLogical l = arg.asLogical();
        return l.size() >= 1 && l.getLogical(0) == 1;
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ai = this.check(call, names, exprs);
        final int posX = ai.position("x");
        final int posWhich = ai.position("which");
        final int posExact = ai.position("exact");
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                boolean exactRequested;
                RAny x = args[posX];
                RSymbol which = Attr.parseWhich(args[posWhich], this.ast);
                RAny res = this.getExactMatchOrNull(x, which);
                if (res != null) {
                    return res;
                }
                boolean bl = exactRequested = posExact != -1 ? Attr.parseExact(args[posExact]) : false;
                if (exactRequested) {
                    return RNull.getNull();
                }
                if (RSymbol.DIM_SYMBOL.startsWith(which)) {
                    res = DimensionsBase.getDim(x);
                } else if (RSymbol.NAMES_SYMBOL.startsWith(which)) {
                    res = Names.getNames(x);
                }
                RAny.Attributes attr = x.attributes();
                if (attr == null) {
                    return this.convertNullToRNull(res);
                }
                if (which == RSymbol.NA_SYMBOL) {
                    return RNull.getNull();
                }
                if (attr.hasPartialMap()) {
                    RSymbol fullName = attr.partialFind(which);
                    if (fullName == null) {
                        return this.convertNullToRNull(res);
                    }
                    if (res != null) {
                        return RNull.getNull();
                    }
                    return this.convertNullToRNull(attr.map().get(fullName));
                }
                LinkedHashMap<RSymbol, RAny> map = attr.map();
                if (map.size() > 256) {
                    attr.createPartialMap();
                }
                for (Map.Entry entry : map.entrySet()) {
                    String sentry = ((RSymbol)entry.getKey()).name();
                    if (!sentry.startsWith(which.name())) continue;
                    if (res != null) {
                        return RNull.getNull();
                    }
                    res = (RAny)entry.getValue();
                }
                return this.convertNullToRNull(res);
            }

            private RAny convertNullToRNull(RAny res) {
                return res != null ? res : RNull.getNull();
            }

            private RAny getExactMatchOrNull(RAny x, RSymbol which) {
                if (which == RSymbol.DIM_SYMBOL) {
                    return DimensionsBase.getDim(x);
                }
                if (which == RSymbol.NAMES_SYMBOL) {
                    return Names.getNames(x);
                }
                RAny.Attributes attr = x.attributes();
                if (attr == null) {
                    return null;
                }
                LinkedHashMap<RSymbol, RAny> map = attr.map();
                return (RAny)map.get(which);
            }
        };
    }
}

