/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.builtins.DimAssign;
import r.builtins.NamesAssign;
import r.data.RAny;
import r.data.RNull;
import r.data.RString;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class AttrAssign
extends CallFactory {
    static final CallFactory _ = new AttrAssign("attr<-", new String[]{"x", "which", "value"}, null);

    private AttrAssign(String name, String[] parameters, String[] required) {
        super(name, parameters, required);
    }

    static RSymbol parseWhich(RAny arg, ASTNode ast) {
        String str;
        RString astr;
        if (arg instanceof RString && (astr = (RString)arg).size() == 1 && (str = astr.getString(0)) != RString.NA) {
            return RSymbol.getSymbol(str);
        }
        throw RError.getMustBeNonNullString(ast, "which");
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ai = this.check(call, names, exprs);
        final int posWhich = ai.position("which");
        final int posValue = ai.position("value");
        final int posX = ai.position("x");
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                RAny x = args[posX];
                RSymbol which = AttrAssign.parseWhich(args[posWhich], this.ast);
                RAny value = args[posValue];
                if (which == RSymbol.NAMES_SYMBOL) {
                    return NamesAssign.replaceNames(x, value, this.ast);
                }
                if (which == RSymbol.DIM_SYMBOL) {
                    return DimAssign.replaceDims(x, value, this.ast);
                }
                value.ref();
                RAny.Attributes attr = x.attributes();
                if (!x.isShared() && attr != null && !attr.areShared()) {
                    AttrAssign.putOrRemove(attr, which, value);
                    return x;
                }
                x = x.isShared() ? Utils.copyAny(x) : x;
                attr = attr == null ? new RAny.Attributes() : attr.copy();
                AttrAssign.putOrRemove(attr, which, value);
                return x.setAttributes(attr);
            }
        };
    }

    public static void putOrRemove(RAny.Attributes attr, RSymbol name, RAny value) {
        if (value instanceof RNull) {
            attr.remove(name);
        } else {
            attr.put(name, value);
        }
    }
}

