/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import java.util.LinkedHashMap;
import java.util.Map;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RInt;
import r.data.RList;
import r.data.RNull;
import r.data.RString;
import r.data.RSymbol;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

class Attributes
extends CallFactory {
    static final CallFactory _ = new Attributes("attributes", new String[]{"obj"}, null);

    Attributes(String name, String[] parameters, String[] required) {
        super(name, parameters, required);
    }

    private static int countSpecialAttributes(RAny a) {
        if (!(a instanceof RArray)) {
            return 0;
        }
        RArray arr = (RArray)a;
        int i = arr.dimensions() == null ? 0 : 1;
        int j = arr.names() == null ? 0 : 1;
        return i + j;
    }

    private static RInt dimensionsAsVector(int[] dimensions) {
        return RInt.RIntFactory.getFor(dimensions);
    }

    private static RString namesAsVector(RArray.Names names) {
        return RString.RStringFactory.getFor(names.asStringArray());
    }

    private static RAny specialAttributesAsList(RAny value) {
        int size = Attributes.countSpecialAttributes(value);
        if (size == 0) {
            return RNull.getNull();
        }
        RAny[] acontent = new RAny[size];
        RSymbol[] anames = new RSymbol[size];
        Attributes.fillSpecialAttributes(acontent, anames, 0, value);
        return RList.RListFactory.getFor(acontent, null, RArray.Names.create(anames));
    }

    private static void fillSpecialAttributes(RAny[] content, RSymbol[] names, int start, RAny value) {
        if (!(value instanceof RArray)) {
            return;
        }
        RArray arr = (RArray)value;
        int i = start;
        if (arr.dimensions() != null) {
            content[i] = Attributes.dimensionsAsVector(arr.dimensions());
            names[i] = RSymbol.DIM_SYMBOL;
            ++i;
        }
        if (arr.names() != null) {
            content[i] = Attributes.namesAsVector(arr.names());
            names[i] = RSymbol.NAMES_SYMBOL;
        }
    }

    private static void fillAttributes(RAny[] content, RSymbol[] names, int start, Map<RSymbol, RAny> map) {
        int i = start;
        for (Map.Entry<RSymbol, RAny> entry : map.entrySet()) {
            content[i] = entry.getValue();
            names[i] = entry.getKey();
            ++i;
        }
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        this.check(call, names, exprs);
        return new Builtin.Builtin1(call, names, exprs){

            @Override
            public final RAny doBuiltIn(Frame frame, RAny arg) {
                RAny.Attributes attr = arg.attributes();
                if (attr == null) {
                    return Attributes.specialAttributesAsList(arg);
                }
                LinkedHashMap<RSymbol, RAny> map = attr.map();
                int nspecial = Attributes.countSpecialAttributes(arg);
                int ncustom = map.size();
                int size = nspecial + ncustom;
                RAny[] acontent = new RAny[size];
                RSymbol[] anames = new RSymbol[size];
                Attributes.fillSpecialAttributes(acontent, anames, 0, arg);
                Attributes.fillAttributes(acontent, anames, nspecial, map);
                return RList.RListFactory.getFor(acontent, null, RArray.Names.create(anames));
            }
        };
    }
}

