/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Utils;
import r.builtins.AttrAssign;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.builtins.DimAssign;
import r.builtins.NamesAssign;
import r.data.RAny;
import r.data.RList;
import r.data.RNull;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

class AttributesAssign
extends CallFactory {
    static final CallFactory _ = new AttributesAssign("attributes<-", new String[]{"obj", "value"}, null);

    AttributesAssign(String name, String[] parameters, String[] required) {
        super(name, parameters, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        this.check(call, names, exprs);
        return new Builtin.Builtin2(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny objArg, RAny valueArg) {
                RAny obj = objArg;
                if (valueArg instanceof RList) {
                    RAny.Attributes attr = new RAny.Attributes();
                    RList value = (RList)valueArg;
                    if (value.names() == null) {
                        throw RError.getAttributesNamed(this.ast);
                    }
                    RSymbol[] vnames = value.names().sequence();
                    for (int i = 0; i < value.size(); ++i) {
                        RAny v = value.getRAny(i);
                        RSymbol s = vnames[i];
                        if (s == RSymbol.EMPTY_SYMBOL) {
                            throw RError.getAllAttributesNames(this.ast, i + 1);
                        }
                        if (s == RSymbol.NAMES_SYMBOL) {
                            obj = NamesAssign.replaceNames(obj, v, this.ast);
                            continue;
                        }
                        if (s == RSymbol.DIM_SYMBOL) {
                            obj = DimAssign.replaceDims(obj, v, this.ast);
                            continue;
                        }
                        v.ref();
                        AttrAssign.putOrRemove(attr, s, v);
                    }
                    RAny res = obj.isShared() ? Utils.copyAny(obj) : obj;
                    return res.setAttributes(attr);
                }
                if (valueArg instanceof RNull) {
                    return objArg.stripAttributes();
                }
                throw RError.getAttributesListOrNull(this.ast);
            }
        };
    }
}

