/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.data.RAny;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RSymbol;
import r.nodes.ast.ASTNode;
import r.nodes.ast.Constant;
import r.nodes.exec.AbstractCall;
import r.nodes.exec.RNode;
import r.runtime.Frame;

public abstract class Builtin
extends AbstractCall {
    public Builtin(ASTNode orig, RSymbol[] argNames, RNode[] argExprs) {
        super(orig, argNames, argExprs);
    }

    public static RAny getConstantValue(RNode node) {
        return node.getAST() instanceof Constant ? (RAny)node.execute(null) : null;
    }

    public static boolean isLogicalConstant(RNode node, int cvalue) {
        RAny value = Builtin.getConstantValue(node);
        if (value == null || !(value instanceof RLogical)) {
            return false;
        }
        RLogical lv = (RLogical)value;
        return lv.size() == 1 ? lv.getLogical(0) == cvalue : false;
    }

    public static boolean isNumericConstant(RNode node, double cvalue) {
        boolean ok;
        RAny value = Builtin.getConstantValue(node);
        if (value == null) {
            return false;
        }
        boolean bl = ok = value instanceof RDouble || value instanceof RInt || value instanceof RLogical;
        if (!ok) {
            return false;
        }
        RDouble dv = value.asDouble();
        return dv.size() == 1 ? dv.getDouble(0) == cvalue : false;
    }

    @Override
    public Object execute(Frame frame) {
        return this.doBuiltIn(frame, this.evalArgs(frame));
    }

    public abstract RAny doBuiltIn(Frame var1, RAny[] var2);

    private RAny[] evalArgs(Frame frame) {
        int len = this.argExprs.length;
        RAny[] args = new RAny[len];
        for (int i = 0; i < len; ++i) {
            RNode expr = this.argExprs[i];
            if (expr == null) continue;
            args[i] = (RAny)expr.execute(frame);
        }
        return args;
    }

    static abstract class Builtin2
    extends Builtin {
        public Builtin2(ASTNode orig, RSymbol[] argNames, RNode[] argExprs) {
            super(orig, argNames, argExprs);
        }

        @Override
        public final Object execute(Frame frame) {
            return this.doBuiltIn(frame, (RAny)this.argExprs[0].execute(frame), (RAny)this.argExprs[1].execute(frame));
        }

        public abstract RAny doBuiltIn(Frame var1, RAny var2, RAny var3);

        @Override
        public final RAny doBuiltIn(Frame frame, RAny[] params) {
            return this.doBuiltIn(frame, params[0], params[1]);
        }
    }

    static abstract class Builtin1
    extends Builtin {
        public Builtin1(ASTNode orig, RSymbol[] argNames, RNode[] argExprs) {
            super(orig, argNames, argExprs);
        }

        @Override
        public final Object execute(Frame frame) {
            return this.doBuiltIn(frame, (RAny)this.argExprs[0].execute(frame));
        }

        public abstract RAny doBuiltIn(Frame var1, RAny var2);

        @Override
        public final RAny doBuiltIn(Frame frame, RAny[] params) {
            return this.doBuiltIn(frame, params[0]);
        }
    }

    static abstract class Builtin0
    extends Builtin {
        public Builtin0(ASTNode orig, RSymbol[] argNames, RNode[] argExprs) {
            super(orig, argNames, argExprs);
        }

        @Override
        public final Object execute(Frame frame) {
            return this.doBuiltIn(frame);
        }

        public abstract RAny doBuiltIn(Frame var1);

        @Override
        public final RAny doBuiltIn(Frame frame, RAny[] params) {
            return this.doBuiltIn(frame);
        }
    }
}

