/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Convert;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RList;
import r.data.RLogical;
import r.data.RNull;
import r.data.RRaw;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.ListImpl;
import r.data.internal.NonScalarArrayImpl;
import r.data.internal.ScalarDoubleImpl;
import r.data.internal.ScalarIntImpl;
import r.data.internal.ScalarLogicalImpl;
import r.data.internal.ScalarStringImpl;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;
import r.runtime.SpecializationException;

final class C
extends CallFactory {
    static final CallFactory _ = new C("c", new String[]{"...", "recursive"}, new String[0]);

    private C(String name, String[] parameters, String[] required) {
        super(name, parameters, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        RSymbol[] collapsedNames = C.collapseEmptyNames(names);
        if (exprs.length == 0) {
            return new Builtin.Builtin0(call, collapsedNames, exprs){

                @Override
                public RAny doBuiltIn(Frame frame) {
                    return RNull.getNull();
                }
            };
        }
        return Specialized.createUninitialized(call, collapsedNames, exprs);
    }

    private static <T extends RArray, U extends T> int fillIn(U result, T input, int offset) {
        int len = input.size();
        for (int i = 0; i < len; ++i) {
            result.set(offset + i, input.get(i));
        }
        return offset + len;
    }

    private static int fillDoubleInComplex(RComplex result, RDouble input, int offset) {
        int len = input.size();
        for (int i = 0; i < len; ++i) {
            result.set(offset + i, input.getDouble(i), 0.0);
        }
        return offset + len;
    }

    public static RAny genericCombine(RSymbol[] paramNames, RAny[] params) {
        return C.genericCombine(paramNames, params, false);
    }

    public static RAny genericCombine(RSymbol[] paramNames, RAny[] params, boolean dropNames) {
        RArray res;
        int len = 0;
        boolean hasNames = paramNames != null;
        boolean hasNull = false;
        boolean hasRaw = false;
        boolean hasLogical = false;
        boolean hasInt = false;
        boolean hasList = false;
        boolean hasDouble = false;
        boolean hasComplex = false;
        boolean hasString = false;
        for (int i = 0; i < params.length; ++i) {
            RAny v = params[i];
            if (v instanceof RNull) {
                hasNull = true;
                continue;
            }
            if (v instanceof RList) {
                hasList = true;
            } else if (v instanceof RString) {
                hasString = true;
            } else if (v instanceof RComplex) {
                hasComplex = true;
            } else if (v instanceof RDouble) {
                hasDouble = true;
            } else if (v instanceof RInt) {
                hasInt = true;
            } else if (v instanceof RLogical) {
                hasLogical = true;
            } else if (v instanceof RRaw) {
                hasRaw = true;
            } else {
                throw Utils.nyi("unsupported type");
            }
            RArray a = (RArray)v;
            len += a.size();
            if (dropNames || a.names() == null) continue;
            hasNames = true;
        }
        int offset = 0;
        RArray.Names newNames = null;
        if (!dropNames && hasNames) {
            RSymbol[] names = new RSymbol[len];
            int j = 0;
            for (int i = 0; i < params.length; ++i) {
                RSymbol[] aNames;
                RAny v = params[i];
                if (v instanceof RNull) continue;
                RArray a = (RArray)v;
                int asize = a.size();
                RArray.Names aNamesPacked = a.names();
                RSymbol[] rSymbolArray = aNames = aNamesPacked == null ? null : aNamesPacked.sequence();
                if (aNames == null) {
                    if (paramNames == null || paramNames[i] == null) {
                        for (int k = 0; k < asize; ++k) {
                            names[j++] = RSymbol.EMPTY_SYMBOL;
                        }
                        continue;
                    }
                    if (asize == 1) {
                        names[j++] = paramNames[i];
                        continue;
                    }
                    if (asize == 0) continue;
                    String prefix = paramNames[i].pretty();
                    for (int k = 0; k < asize; ++k) {
                        String n = prefix + (k + 1);
                        names[j++] = RSymbol.getSymbol(n);
                    }
                    continue;
                }
                if (paramNames == null || paramNames[i] == RSymbol.EMPTY_SYMBOL || paramNames[i] == null) {
                    for (int k = 0; k < asize; ++k) {
                        names[j++] = aNames[k];
                    }
                    continue;
                }
                String eprefix = paramNames[i].pretty();
                String prefix = eprefix + ".";
                for (int k = 0; k < asize; ++k) {
                    RSymbol ksymbol = aNames[k];
                    if (ksymbol == RSymbol.EMPTY_SYMBOL) {
                        if (asize == 1) {
                            names[j++] = paramNames[i];
                            continue;
                        }
                        names[j++] = RSymbol.getSymbol(eprefix + (k + 1));
                        continue;
                    }
                    String n = prefix + Convert.prettyNA(ksymbol.pretty());
                    names[j++] = RSymbol.getSymbol(n);
                }
            }
            newNames = RArray.Names.create(names);
        }
        if (hasList) {
            res = RList.RListFactory.getUninitializedArray(len);
            for (RAny v : params) {
                if (v instanceof RNull) continue;
                RArray a = (RArray)v;
                int asize = a.size();
                if (v instanceof RList) {
                    RList l = (RList)v;
                    for (int i = 0; i < asize; ++i) {
                        RAny ll = l.getRAnyRef(i);
                        ((ListImpl)res).set(offset + i, ll);
                    }
                } else {
                    for (int i = 0; i < asize; ++i) {
                        ((ListImpl)res).set(offset + i, a.boxedGet(i));
                    }
                }
                offset += asize;
            }
            return ((NonScalarArrayImpl)res).setNames(newNames);
        }
        if (hasString) {
            res = RString.RStringFactory.getUninitializedArray(len);
            for (RAny v : params) {
                if (v instanceof RNull) continue;
                offset = C.fillIn(res, v instanceof RString ? (RString)v : v.asString(), offset);
            }
            return res.setNames(newNames);
        }
        if (hasComplex) {
            res = RComplex.RComplexFactory.getUninitializedArray(len);
            for (RAny v : params) {
                if (v instanceof RNull) continue;
                offset = v instanceof RDouble ? C.fillDoubleInComplex((RComplex)res, (RDouble)v, offset) : C.fillIn(res, v instanceof RComplex ? (RComplex)v : v.asComplex(), offset);
            }
            return res.setNames(newNames);
        }
        if (hasDouble) {
            res = RDouble.RDoubleFactory.getUninitializedArray(len);
            for (RAny v : params) {
                if (v instanceof RNull) continue;
                offset = C.fillIn(res, v instanceof RDouble ? (RDouble)v : v.asDouble(), offset);
            }
            return res.setNames(newNames);
        }
        if (hasInt) {
            res = RInt.RIntFactory.getUninitializedArray(len);
            for (RAny v : params) {
                if (v instanceof RNull) continue;
                offset = C.fillIn(res, v instanceof RInt ? (RInt)v : v.asInt(), offset);
            }
            return res.setNames(newNames);
        }
        if (hasLogical) {
            res = RLogical.RLogicalFactory.getUninitializedArray(len);
            for (RAny v : params) {
                if (v instanceof RNull) continue;
                offset = C.fillIn(res, v instanceof RLogical ? (RLogical)v : v.asLogical(), offset);
            }
            return res.setNames(newNames);
        }
        if (hasRaw) {
            res = RRaw.RRawFactory.getUninitializedArray(len);
            for (RAny v : params) {
                if (v instanceof RNull) continue;
                offset = C.fillIn(res, v instanceof RRaw ? (RRaw)v : v.asRaw(), offset);
            }
            return res.setNames(newNames);
        }
        if (hasNull) {
            return RNull.getNull();
        }
        throw Utils.nyi("Unreacheable");
    }

    public static Builtin createGeneric(ASTNode ast, final RSymbol[] names, RNode[] exprs) {
        return new Builtin(ast, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] params) {
                return C.genericCombine(names, params);
            }
        };
    }

    public static RSymbol[] collapseEmptyNames(RSymbol[] names) {
        if (names == null) {
            return names;
        }
        for (RSymbol s : names) {
            if (s == null) continue;
            return names;
        }
        return null;
    }

    public static class Specialized
    extends Builtin {
        CombineAction combine;

        public Specialized(ASTNode orig, RSymbol[] argNames, RNode[] argExprs, CombineAction combine) {
            super(orig, argNames, argExprs);
            this.combine = combine;
        }

        public static Specialized createUninitialized(ASTNode ast, RSymbol[] names, RNode[] exprs) {
            return Specialized.createTransition(ast, names, exprs, Transition.SIMPLE_SCALARS);
        }

        public static Specialized createTransition(ASTNode ast, RSymbol[] names, RNode[] exprs, final Transition t) {
            CombineAction a = new CombineAction(){

                @Override
                public final RAny combine(Frame frame, RAny[] params) throws SpecializationException {
                    throw new SpecializationException((Object)t);
                }
            };
            return new Specialized(ast, names, exprs, a);
        }

        public static Specialized createSimpleScalars(ASTNode ast, RSymbol[] names, RNode[] exprs, RAny typeTemplate) {
            if (names != null) {
                return Specialized.createTransition(ast, names, exprs, Transition.GENERIC);
            }
            if (typeTemplate instanceof ScalarStringImpl) {
                CombineAction a = new CombineAction(){

                    @Override
                    public final RAny combine(Frame frame, RAny[] params) throws SpecializationException {
                        int size = params.length;
                        String[] content = new String[size];
                        for (int i = 0; i < size; ++i) {
                            RAny v = params[i];
                            if (!(v instanceof ScalarStringImpl)) {
                                throw new SpecializationException((Object)Transition.CASTING_SCALARS);
                            }
                            content[i] = ((ScalarStringImpl)v).getString();
                        }
                        return RString.RStringFactory.getFor(content);
                    }
                };
                return new Specialized(ast, names, exprs, a);
            }
            if (typeTemplate instanceof ScalarDoubleImpl) {
                CombineAction a = new CombineAction(){

                    @Override
                    public final RAny combine(Frame frame, RAny[] params) throws SpecializationException {
                        int size = params.length;
                        double[] content = new double[size];
                        for (int i = 0; i < size; ++i) {
                            RAny v = params[i];
                            if (!(v instanceof ScalarDoubleImpl)) {
                                throw new SpecializationException((Object)Transition.CASTING_SCALARS);
                            }
                            content[i] = ((ScalarDoubleImpl)v).getDouble();
                        }
                        return RDouble.RDoubleFactory.getFor(content);
                    }
                };
                return new Specialized(ast, names, exprs, a);
            }
            if (typeTemplate instanceof ScalarIntImpl) {
                CombineAction a = new CombineAction(){

                    @Override
                    public final RAny combine(Frame frame, RAny[] params) throws SpecializationException {
                        int size = params.length;
                        int[] content = new int[size];
                        for (int i = 0; i < size; ++i) {
                            RAny v = params[i];
                            if (!(v instanceof ScalarIntImpl)) {
                                throw new SpecializationException((Object)Transition.CASTING_SCALARS);
                            }
                            content[i] = ((ScalarIntImpl)v).getInt();
                        }
                        return RInt.RIntFactory.getFor(content);
                    }
                };
                return new Specialized(ast, names, exprs, a);
            }
            if (typeTemplate instanceof ScalarLogicalImpl) {
                CombineAction a = new CombineAction(){

                    @Override
                    public final RAny combine(Frame frame, RAny[] params) throws SpecializationException {
                        int size = params.length;
                        int[] content = new int[size];
                        for (int i = 0; i < size; ++i) {
                            RAny v = params[i];
                            if (!(v instanceof ScalarLogicalImpl)) {
                                throw new SpecializationException((Object)Transition.CASTING_SCALARS);
                            }
                            content[i] = ((ScalarLogicalImpl)v).getLogical();
                        }
                        return RLogical.RLogicalFactory.getFor(content);
                    }
                };
                return new Specialized(ast, names, exprs, a);
            }
            return Specialized.createTransition(ast, names, exprs, Transition.GENERIC);
        }

        public static Specialized createCastingScalars(ASTNode ast, RSymbol[] names, RNode[] exprs, RAny typeTemplate) {
            if (names != null) {
                return Specialized.createTransition(ast, names, exprs, Transition.GENERIC);
            }
            if (typeTemplate instanceof RDouble) {
                CombineAction a = new CombineAction(){

                    @Override
                    public final RAny combine(Frame frame, RAny[] params) throws SpecializationException {
                        int size = params.length;
                        double[] content = new double[size];
                        for (int i = 0; i < size; ++i) {
                            RAny v = params[i];
                            if (v instanceof ScalarDoubleImpl) {
                                content[i] = ((ScalarDoubleImpl)v).getDouble();
                                continue;
                            }
                            if (v instanceof ScalarIntImpl) {
                                content[i] = Convert.int2double(((ScalarIntImpl)v).getInt());
                                continue;
                            }
                            if (v instanceof ScalarLogicalImpl) {
                                content[i] = Convert.logical2double(((ScalarLogicalImpl)v).getLogical());
                                continue;
                            }
                            throw new SpecializationException((Object)Transition.GENERIC);
                        }
                        return RDouble.RDoubleFactory.getFor(content);
                    }
                };
                return new Specialized(ast, names, exprs, a);
            }
            if (typeTemplate instanceof RInt) {
                CombineAction a = new CombineAction(){

                    @Override
                    public final RAny combine(Frame frame, RAny[] params) throws SpecializationException {
                        int size = params.length;
                        int[] content = new int[size];
                        for (int i = 0; i < size; ++i) {
                            RAny v = params[i];
                            if (v instanceof ScalarIntImpl) {
                                content[i] = ((ScalarIntImpl)v).getInt();
                                continue;
                            }
                            if (v instanceof ScalarLogicalImpl) {
                                content[i] = Convert.logical2int(((ScalarLogicalImpl)v).getLogical());
                                continue;
                            }
                            throw new SpecializationException((Object)Transition.GENERIC);
                        }
                        return RInt.RIntFactory.getFor(content);
                    }
                };
                return new Specialized(ast, names, exprs, a);
            }
            return Specialized.createTransition(ast, names, exprs, Transition.GENERIC);
        }

        @Override
        public final RAny doBuiltIn(Frame frame, RAny[] params) {
            try {
                return this.combine.combine(frame, params);
            }
            catch (SpecializationException e) {
                Transition t = (Transition)((Object)e.getResult());
                Specialized s = null;
                switch (t) {
                    case SIMPLE_SCALARS: {
                        s = Specialized.createSimpleScalars(this.ast, this.argNames, this.argExprs, params[0]);
                        this.replace(s, "install SimpleScalars in Combine.Specialized");
                        return s.doBuiltIn(frame, params);
                    }
                    case CASTING_SCALARS: {
                        RAny res = C.genericCombine(this.argNames, params);
                        s = Specialized.createCastingScalars(this.ast, this.argNames, this.argExprs, res);
                        this.replace(s, "install CastingScalars in Combine.Specialized");
                        return res;
                    }
                }
                this.replace(C.createGeneric(this.ast, this.argNames, this.argExprs), "install Generic in Combine.Specialized");
                return C.genericCombine(this.argNames, params);
            }
        }
    }

    public static abstract class CombineAction {
        public abstract RAny combine(Frame var1, RAny[] var2) throws SpecializationException;
    }

    static enum Transition {
        SIMPLE_SCALARS,
        CASTING_SCALARS,
        SIMPLE_VECTORS,
        GENERIC;

    }
}

