/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RLanguage;
import r.data.RString;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.ast.ArgumentList;
import r.nodes.ast.Constant;
import r.nodes.ast.FunctionCall;
import r.nodes.exec.RNode;
import r.runtime.Frame;

public class Call
extends CallFactory {
    static final CallFactory _ = new Call("call", new String[]{"name", "..."}, new String[]{"name"});

    private Call(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, final RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int posName = ia.position("name");
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                RSymbol functionName = Call.parseName(args[posName], this.ast);
                ArgumentList.Default list = new ArgumentList.Default();
                for (int i = 0; i < args.length; ++i) {
                    if (i == posName) continue;
                    list.add(names[i], (ASTNode)new Constant(args[i]));
                }
                return new RLanguage(new FunctionCall(functionName, list));
            }
        };
    }

    public static RSymbol parseName(RAny arg, ASTNode ast) {
        RString sarg;
        if (arg instanceof RString && (sarg = (RString)arg).size() == 1) {
            RSymbol s = RSymbol.getSymbol(sarg.getString(0));
            if (s == RSymbol.EMPTY_SYMBOL) {
                throw RError.getZeroLengthVariable(ast);
            }
            return s;
        }
        throw RError.getFirstArgMustBeArray(ast);
    }
}

