/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import java.util.ArrayList;
import r.RContext;
import r.Utils;
import r.data.RAny;
import r.data.RLogical;
import r.data.RNull;
import r.data.RString;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.BaseR;
import r.nodes.exec.Constant;
import r.nodes.exec.RNode;
import r.nodes.tools.PrettyPrinter;
import r.runtime.Frame;

public abstract class CallFactory {
    final RSymbol name;
    private RSymbol[] parameters;
    private RSymbol[] required;
    final int maxParameters;
    final int minParameters;

    public CallFactory(String name) {
        this.name = RSymbol.getSymbol(name);
        this.maxParameters = -1;
        this.minParameters = -1;
    }

    protected CallFactory(String name, String[] parameters, String[] required) {
        this.name = RSymbol.getSymbol(name);
        this.parameters = RSymbol.getSymbols(parameters);
        this.required = required == null ? this.parameters : RSymbol.getSymbols(required);
        boolean dotdot = false;
        if (this.required != this.parameters) {
            for (RSymbol r : this.required) {
                boolean match = false;
                for (RSymbol p : this.parameters) {
                    match |= r == p;
                }
                if (match) continue;
                throw Utils.nyi("Internal error in builtin definition for " + name + "required list has extra values");
            }
        }
        RSymbol[] minPs = new RSymbol[parameters.length];
        int pos = 0;
        for (RSymbol p : this.parameters) {
            if (dotdot |= p == RSymbol.THREE_DOTS_SYMBOL) continue;
            minPs[pos++] = p;
        }
        int min = 0;
        block3: for (int i = 0; i < pos; ++i) {
            for (RSymbol r : this.required) {
                if (minPs[i] != r) continue;
                ++min;
                continue block3;
            }
        }
        this.maxParameters = dotdot ? Integer.MAX_VALUE : parameters.length;
        this.minParameters = min;
    }

    public abstract RNode create(ASTNode var1, RSymbol[] var2, RNode[] var3);

    public RNode create(ASTNode call, RNode left, RNode right) {
        return this.create(call, null, new RNode[]{left, right});
    }

    ArgumentInfo resolveArguments(RSymbol[] argNames, RNode[] argExprs, ASTNode ast) {
        ArgumentInfo a = new ArgumentInfo(this.parameters);
        int nArgs = argExprs.length;
        int nParams = this.parameters.length;
        boolean[] argUsed = new boolean[nArgs];
        if (argNames != null) {
            for (int i = 0; i < nArgs; ++i) {
                RSymbol argName = argNames[i];
                if (argName == null) continue;
                for (int j = 0; j < nParams; ++j) {
                    if (argName != this.parameters[j]) continue;
                    if (a.paramPositions[j] != -1) {
                        throw RError.getFormalMatchedMultiple(ast, argName.name());
                    }
                    a.paramPositions[j] = i;
                    argUsed[i] = true;
                }
            }
        }
        if (argNames != null) {
            boolean[] argUsedForPatternMatching = new boolean[nArgs];
            for (int j = 0; j < nParams; ++j) {
                if (a.paramPositions[j] != -1) continue;
                RSymbol paramName = this.parameters[j];
                if (paramName == RSymbol.THREE_DOTS_SYMBOL) break;
                boolean paramMatched = false;
                for (int i = 0; i < nArgs; ++i) {
                    RSymbol argName = argNames[i];
                    if (argName == null || argUsed[i] && !argUsedForPatternMatching[i] || !paramName.startsWith(argName)) continue;
                    if (argUsedForPatternMatching[i]) {
                        throw RError.getArgumentMatchesMultiple(ast, i + 1);
                    }
                    if (paramMatched) {
                        throw RError.getFormalMatchedMultiple(ast, paramName.name());
                    }
                    a.paramPositions[j] = i;
                    argUsed[i] = true;
                    argUsedForPatternMatching[i] = true;
                    paramMatched = true;
                }
            }
        }
        int j = 0;
        for (int i = 0; i < nArgs; ++i) {
            if (argUsed[i]) continue;
            while (j < nParams && a.paramPositions[j] != -1 && this.parameters[j] != RSymbol.THREE_DOTS_SYMBOL) {
                ++j;
            }
            if (j == nParams) {
                if (a.unusedArgs == null) {
                    a.unusedArgs = new ArrayList();
                }
                a.unusedArgs.add(i);
                continue;
            }
            if (this.parameters[j] == RSymbol.THREE_DOTS_SYMBOL) {
                if (argExprs[i] == null) {
                    throw RError.getArgumentEmpty(ast, i + 1);
                }
                a.paramPositions[j] = i;
                continue;
            }
            if (argExprs[i] != null) {
                if (argNames != null && argNames[i] != null) {
                    throw RError.getUnusedArgument(ast, argNames[i], argExprs[i]);
                }
                a.paramPositions[j] = i;
                continue;
            }
            ++j;
        }
        return a;
    }

    int ix(RSymbol p) {
        for (int i = 0; i < this.parameters.length; ++i) {
            if (this.parameters[i] != p) continue;
            return i;
        }
        throw Utils.nyi(p + " not found  in  " + this);
    }

    int ix(String p) {
        return this.ix(RSymbol.getSymbol(p));
    }

    public RSymbol name() {
        return this.name;
    }

    protected ArgumentInfo check(ASTNode call, RSymbol[] names, RNode[] exprs) {
        int i;
        assert (Utils.check(this.detectRepeatedParameters(call)));
        ArgumentInfo ai = this.resolveArguments(names, exprs, call);
        int provided = 0;
        for (i = 0; i < ai.paramPositions.length; ++i) {
            if (ai.paramPositions[i] == -1) continue;
            ++provided;
        }
        if (provided < this.minParameters) {
            for (i = 0; i < this.required.length; ++i) {
                if (ai.paramPositions[this.ix(this.required[i])] != -1) continue;
                throw RError.getArgumentMissing(call, this.required[i].name());
            }
        }
        if (exprs.length < this.minParameters) {
            throw RError.getWrongArity(call, this.name().name(), this.minParameters, exprs.length);
        }
        if (ai.unusedArgs != null) {
            throw RError.getWrongArity(call, this.name().name(), this.maxParameters, exprs.length);
        }
        return ai;
    }

    boolean detectRepeatedParameters(ASTNode ast) {
        int n = this.parameters.length;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (this.parameters[i] != this.parameters[j]) continue;
                Utils.nyi("Repeated formal argument \"" + this.parameters[i] + "\" in a builtin: " + PrettyPrinter.prettyPrint(ast));
            }
        }
        return true;
    }

    static void ensureArgName(ASTNode ast, String expectedName, RSymbol actualName) {
        if (actualName == null) {
            return;
        }
        RSymbol expected = RSymbol.getSymbol(expectedName);
        if (actualName != expected) {
            throw RError.getGenericError(ast, String.format("supplied argument name '%s' does not match '%s'", actualName.pretty(), expectedName));
        }
    }

    public String toString() {
        String res = "CallFactory[" + this.name + "(";
        for (RSymbol r : this.parameters) {
            res = res + r + " ";
        }
        return res + ")]";
    }

    public static boolean parseUncheckedLogical(RAny arg, ASTNode ast) {
        RLogical l = arg.asLogical();
        int size = l.size();
        if (size >= 1) {
            int v = l.getLogical(0);
            if (v == Integer.MIN_VALUE) {
                throw RError.getUnexpectedNA(ast);
            }
            if (size > 1) {
                RContext.warning(ast, "the condition has length > 1 and only the first element will be used");
            }
            return v == 1;
        }
        throw RError.getUnexpectedNA(ast);
    }

    public Object invokeDynamic(Frame frame, RSymbol[] names, RAny[] values, ASTNode ast) {
        int len = values.length;
        RNode[] exprs = new RNode[len];
        for (int i = 0; i < len; ++i) {
            RAny value = values[i];
            r.nodes.ast.Constant dummyAST = new r.nodes.ast.Constant(value);
            exprs[i] = new Constant(dummyAST, value);
        }
        final RNode builtinNode = this.create(ast, names, exprs);
        BaseR rootNode = new BaseR(ast){
            @RNode.Child
            RNode node;
            {
                super(x0);
                this.node = this.adoptChild(builtinNode);
            }

            @Override
            public final Object execute(Frame builtinFrame) {
                return this.node.execute(builtinFrame);
            }

            @Override
            protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
                assert (oldNode != null);
                if (this.node == oldNode) {
                    this.node = newNode;
                    return this.adoptInternal(newNode);
                }
                return super.replaceChild(oldNode, newNode);
            }
        };
        return rootNode.execute(frame);
    }

    public Object invokeDynamic(Frame frame, RSymbol[] names, RNode[] exprs, ASTNode ast) {
        final RNode builtinNode = this.create(ast, names, exprs);
        BaseR rootNode = new BaseR(ast){
            @RNode.Child
            RNode node;
            {
                super(x0);
                this.node = this.adoptChild(builtinNode);
            }

            @Override
            public final Object execute(Frame builtinFrame) {
                return this.node.execute(builtinFrame);
            }

            @Override
            protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
                assert (oldNode != null);
                if (this.node == oldNode) {
                    this.node = newNode;
                    return this.adoptInternal(newNode);
                }
                return super.replaceChild(oldNode, newNode);
            }
        };
        return rootNode.execute(frame);
    }

    static class ArgumentMatch {
        final String[] allowed;

        public ArgumentMatch(String[] allowed) {
            this.allowed = allowed;
        }

        public int match(RAny arg, ASTNode ast, String argName) {
            if (arg instanceof RNull) {
                return 0;
            }
            if (!(arg instanceof RString)) {
                throw RError.getMustNullOrString(ast, argName);
            }
            RString m = (RString)arg;
            if (m.size() != 1) {
                throw RError.getMustBeScalar(ast, argName);
            }
            String s = m.getString(0);
            if (s == RString.NA) {
                throw RError.getArgOneOf(ast, argName, this.allowed);
            }
            int match = -1;
            int nmatches = 0;
            for (int i = 0; i < this.allowed.length; ++i) {
                String a = this.allowed[i];
                if (!a.startsWith(s)) continue;
                if (a.length() == s.length()) {
                    return i;
                }
                ++nmatches;
                match = i;
            }
            if (nmatches == 1) {
                return match;
            }
            throw RError.getArgOneOf(ast, argName, this.allowed);
        }
    }

    public static class ArgumentInfo {
        RSymbol[] parameters;
        int[] paramPositions;
        ArrayList<Integer> unusedArgs;

        ArgumentInfo(RSymbol[] parameters) {
            this.parameters = parameters;
            int nParams = parameters.length;
            this.paramPositions = new int[nParams];
            for (int i = 0; i < this.paramPositions.length; ++i) {
                this.paramPositions[i] = -1;
            }
        }

        private int ix(RSymbol p) {
            for (int i = 0; i < this.parameters.length; ++i) {
                if (this.parameters[i] != p) continue;
                return i;
            }
            throw new Error(p + " not found in " + this);
        }

        private int ix(String p) {
            return this.ix(RSymbol.getSymbol(p));
        }

        boolean provided(String name) {
            return this.paramPositions[this.ix(name)] != -1;
        }

        public int position(String name) {
            return this.paramPositions[this.ix(name)];
        }

        public String toString() {
            String res = "[";
            for (int i = 0; i < this.parameters.length; ++i) {
                res = res + this.parameters[i] + "=" + this.paramPositions[i] + (i == this.parameters.length - 1 ? "" : ",");
            }
            return res + "]";
        }
    }
}

