/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import java.io.PrintWriter;
import r.Convert;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RList;
import r.data.RLogical;
import r.data.RNull;
import r.data.RRaw;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.ScalarStringImpl;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;
import r.runtime.SpecializationException;

final class Cat
extends CallFactory {
    static final CallFactory _ = new Cat("cat", new String[]{"...", "file", "sep", "fill", "labels", "append"}, new String[0]);
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static char[] buffer = new char[4096];

    Cat(String name, String[] parameters, String[] required) {
        super(name, parameters, required);
    }

    static String catElement(RArray v, int i) {
        if (v instanceof RDouble) {
            return Convert.prettyNA(Convert.double2string(((RDouble)v).getDouble(i)));
        }
        if (v instanceof RInt) {
            return Convert.prettyNA(Convert.int2string(((RInt)v).getInt(i)));
        }
        if (v instanceof RLogical) {
            return Convert.prettyNA(Convert.logical2string(((RLogical)v).getLogical(i)));
        }
        if (v instanceof RString) {
            return ((RString)v).getString(i);
        }
        if (v instanceof RComplex) {
            return Cat.catElement((RComplex)v, i);
        }
        if (v instanceof RRaw) {
            return Convert.raw2string(((RRaw)v).getRaw(i));
        }
        throw Utils.nyi("unsupported type");
    }

    static String catElement(RComplex v, int i) {
        return Convert.prettyNA(Convert.complex2string(v.getReal(i), v.getImag(i)));
    }

    static void genericCat(PrintWriter out, RAny[] args, int sepArgPos, ASTNode ast) {
        RString sep = null;
        int ssize = 0;
        if (sepArgPos != -1) {
            RAny v = args[sepArgPos];
            if (!(v instanceof RString)) {
                throw RError.getInvalidSep(ast);
            }
            sep = (RString)v;
            ssize = sep.size();
        }
        int si = 0;
        boolean lastWasNull = false;
        int nprinted = 0;
        for (int i = 0; i < args.length; ++i) {
            RAny v;
            if (i == sepArgPos) continue;
            if (nprinted > 0 && !lastWasNull) {
                if (sep != null) {
                    out.print(sep.getString(si++));
                    if (si == ssize) {
                        si = 0;
                    }
                } else {
                    out.print(" ");
                }
            }
            if ((v = args[i]) instanceof RNull) {
                lastWasNull = true;
                continue;
            }
            lastWasNull = false;
            if (v instanceof RList) {
                throw RError.getGenericError(ast, String.format("argument %d (type 'list') cannot be handled by 'cat'", i + 1));
            }
            if (!(v instanceof RArray)) continue;
            RArray va = (RArray)v;
            int vsize = va.size();
            for (int j = 0; j < vsize; ++j) {
                if (j > 0) {
                    if (sep != null) {
                        out.print(sep.getString(si++));
                        if (si == ssize) {
                            si = 0;
                        }
                    } else {
                        out.print(" ");
                    }
                }
                ++nprinted;
                out.print(Cat.catElement(va, j));
            }
        }
        out.flush();
    }

    static void catStringsBuilder(PrintWriter out, RAny[] args, int sepArgPos, ASTNode ast) throws SpecializationException {
        if (sepArgPos == -1) {
            throw new SpecializationException((Object)null);
        }
        StringBuilder str = new StringBuilder();
        int argslen = args.length;
        for (int j = 0; j < argslen; ++j) {
            RAny arg = args[j];
            if (!(arg instanceof RString)) {
                throw new SpecializationException((Object)null);
            }
            RString rs = (RString)arg;
            int size = rs.size();
            if (j != sepArgPos) {
                for (int i = 0; i < size; ++i) {
                    str.append(rs.getString(i));
                }
                continue;
            }
            if (size == 1 && rs.getString(0).length() <= 0) continue;
            throw new SpecializationException((Object)null);
        }
        out.append(str);
        out.flush();
    }

    static void catStrings(PrintWriter out, RAny[] args, int sepArgPos, ASTNode ast) throws SpecializationException {
        if (sepArgPos == -1) {
            throw new SpecializationException((Object)null);
        }
        int argslen = args.length;
        int bufPos = 0;
        for (int j = 0; j < argslen; ++j) {
            RAny arg = args[j];
            if (!(arg instanceof RString)) {
                throw new SpecializationException((Object)null);
            }
            RString rs = (RString)arg;
            int size = rs.size();
            if (j != sepArgPos) {
                for (int i = 0; i < size; ++i) {
                    String as = rs.getString(i);
                    int asSize = as.length();
                    if (bufPos + asSize > buffer.length) {
                        int newSize;
                        for (newSize = buffer.length * 2; bufPos + asSize > newSize; newSize *= 2) {
                        }
                        char[] oldBuffer = buffer;
                        buffer = new char[newSize];
                        System.arraycopy(oldBuffer, 0, buffer, 0, bufPos);
                    }
                    for (int k = 0; k < asSize; ++k) {
                        Cat.buffer[bufPos++] = as.charAt(k);
                    }
                }
                continue;
            }
            if (size == 1 && rs.getString(0).length() <= 0) continue;
            throw new SpecializationException((Object)null);
        }
        out.write(buffer, 0, bufPos);
        out.flush();
    }

    static void catScalarStringsNoCopy(PrintWriter out, RAny[] args, int sepArgPos, ASTNode ast) throws SpecializationException {
        if (sepArgPos == -1) {
            throw new SpecializationException((Object)null);
        }
        int argslen = args.length;
        for (int j = 0; j < argslen; ++j) {
            RAny arg = args[j];
            if (arg instanceof ScalarStringImpl) continue;
            throw new SpecializationException((Object)null);
        }
        String sep = ((ScalarStringImpl)args[sepArgPos]).getString();
        if (sep.length() != 0) {
            throw new SpecializationException((Object)null);
        }
        for (int j = 0; j < argslen; ++j) {
            String str = ((ScalarStringImpl)args[j]).getString();
            out.write(str);
        }
        out.flush();
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        if (exprs.length == 0) {
            return new Builtin.Builtin0(call, names, exprs){

                @Override
                public RAny doBuiltIn(Frame frame) {
                    return RNull.getNull();
                }
            };
        }
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int sepPosition = ia.provided("sep") ? ia.position("sep") : -1;
        final PrintWriter stdOut = new PrintWriter(System.out, true);
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] params) {
                try {
                    Cat.catStrings(stdOut, params, sepPosition, this.ast);
                }
                catch (SpecializationException e) {
                    Builtin generic = new Builtin(this.ast, this.argNames, this.argExprs){

                        @Override
                        public RAny doBuiltIn(Frame frame, RAny[] params) {
                            Cat.genericCat(stdOut, params, sepPosition, this.ast);
                            return RNull.getNull();
                        }
                    };
                    this.replace(generic, "install Cat.Generic from Cat.Strings.NoSep");
                    Cat.genericCat(stdOut, params, sepPosition, this.ast);
                }
                return RNull.getNull();
            }
        };
    }
}

