/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.RContext;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RList;
import r.data.RLogical;
import r.data.RNull;
import r.data.RRaw;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.ListImpl;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Cbind
extends CallFactory {
    static final CallFactory _ = new Cbind("cbind", new String[]{"...", "deparse.level"}, new String[0]);

    private Cbind(String name, String[] parameters, String[] required) {
        super(name, parameters, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        if (ia.provided("deparse.level")) {
            Utils.nyi("deparse.level not implemented");
        }
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                return Cbind.cbind(args, this.ast);
            }
        };
    }

    private static int fillIn(RArray result, RArray input, int offset, int nrow, ASTNode ast, int argIndex) {
        int[] dims = input.dimensions();
        int isize = input.size();
        if (dims != null && dims.length == 2) {
            for (int i = 0; i < isize; ++i) {
                result.set(offset + i, input.get(i));
            }
            return offset + isize;
        }
        int ii = 0;
        for (int i = 0; i < nrow; ++i) {
            result.set(offset + i, input.get(ii++));
            if (ii != isize) continue;
            ii = 0;
        }
        if (ii != 0) {
            RContext.warning(ast, String.format("number of rows of result is not a multiple of vector length (arg %d)", argIndex + 1));
        }
        return offset + nrow;
    }

    private static int fillInListToList(RList result, RList input, int offset, int nrow, ASTNode ast, int argIndex) {
        int[] dims = input.dimensions();
        int isize = input.size();
        if (dims != null && dims.length == 2) {
            for (int i = 0; i < isize; ++i) {
                result.set(offset + i, input.getRAnyRef(i));
            }
            return offset + isize;
        }
        int ii = 0;
        for (int i = 0; i < nrow; ++i) {
            result.set(offset + i, input.getRAnyRef(ii++));
            if (ii != isize) continue;
            ii = 0;
        }
        if (ii != 0) {
            RContext.warning(ast, String.format("number of rows of result is not a multiple of vector length (arg %d)", argIndex + 1));
        }
        return offset + nrow;
    }

    public static RAny cbind(RAny[] args, ASTNode ast) {
        int ai;
        RArray res;
        int maxVectorSize = 0;
        int ncol = 0;
        int nrow = -1;
        int nargs = args.length;
        boolean hasRaw = false;
        boolean hasLogical = false;
        boolean hasInt = false;
        boolean hasDouble = false;
        boolean hasComplex = false;
        boolean hasString = false;
        boolean hasList = false;
        for (int i = 0; i < nargs; ++i) {
            RAny x = args[i];
            if (x instanceof RNull) continue;
            if (!(x instanceof RArray)) {
                hasList = true;
                ++ncol;
                continue;
            }
            RArray a = (RArray)x;
            int[] dims = a.dimensions();
            if (dims != null && dims.length == 2) {
                if (nrow != dims[0]) {
                    if (nrow == -1) {
                        nrow = dims[0];
                    } else {
                        throw RError.getRowsMustMatch(ast, i + 1);
                    }
                }
                ncol += dims[1];
            } else {
                int asize = a.size();
                if (asize > maxVectorSize) {
                    maxVectorSize = asize;
                }
                ++ncol;
            }
            if (a instanceof RDouble) {
                hasDouble = true;
                continue;
            }
            if (a instanceof RInt) {
                hasInt = true;
                continue;
            }
            if (a instanceof RLogical) {
                hasLogical = true;
                continue;
            }
            if (a instanceof RList) {
                hasList = true;
                continue;
            }
            if (a instanceof RString) {
                hasString = true;
                continue;
            }
            if (a instanceof RComplex) {
                hasComplex = true;
                continue;
            }
            if (a instanceof RRaw) {
                hasRaw = true;
                continue;
            }
            throw Utils.nyi("unsupported type");
        }
        if (nrow == -1) {
            nrow = maxVectorSize;
        }
        int size = nrow * ncol;
        int offset = 0;
        int[] ndim = new int[]{nrow, ncol};
        if (hasList) {
            res = RList.RListFactory.getUninitializedArray(size, ndim, null, null);
            for (ai = 0; ai < nargs; ++ai) {
                RAny v = args[ai];
                if (v instanceof RList) {
                    offset = Cbind.fillInListToList((RList)res, (RList)v, offset, nrow, ast, ai);
                    continue;
                }
                if (v instanceof RNull) continue;
                if (!(v instanceof RArray)) {
                    for (int i = 0; i < nrow; ++i) {
                        ((ListImpl)res).set(offset + i, v);
                    }
                    offset += nrow;
                    continue;
                }
                offset = Cbind.fillIn(res, v.asList(), offset, nrow, ast, ai);
            }
            return res;
        }
        if (hasString) {
            res = RString.RStringFactory.getUninitializedArray(size, ndim, null, null);
            for (ai = 0; ai < nargs; ++ai) {
                RAny v = args[ai];
                if (v instanceof RNull) continue;
                offset = Cbind.fillIn(res, v.asString(), offset, nrow, ast, ai);
            }
            return res;
        }
        if (hasComplex) {
            res = RComplex.RComplexFactory.getUninitializedArray(size, ndim, null, null);
            for (ai = 0; ai < nargs; ++ai) {
                RAny v = args[ai];
                if (v instanceof RNull) continue;
                offset = Cbind.fillIn(res, v.asComplex(), offset, nrow, ast, ai);
            }
            return res;
        }
        if (hasDouble) {
            res = RDouble.RDoubleFactory.getUninitializedArray(size, ndim, null, null);
            for (ai = 0; ai < nargs; ++ai) {
                RAny v = args[ai];
                if (v instanceof RNull) continue;
                offset = Cbind.fillIn(res, v.asDouble(), offset, nrow, ast, ai);
            }
            return res;
        }
        if (hasInt) {
            res = RInt.RIntFactory.getUninitializedArray(size, ndim, null, null);
            for (ai = 0; ai < nargs; ++ai) {
                RAny v = args[ai];
                if (v instanceof RNull) continue;
                offset = Cbind.fillIn(res, v.asInt(), offset, nrow, ast, ai);
            }
            return res;
        }
        if (hasLogical) {
            res = RLogical.RLogicalFactory.getUninitializedArray(size, ndim, null, null);
            for (ai = 0; ai < nargs; ++ai) {
                RAny v = args[ai];
                if (v instanceof RNull) continue;
                offset = Cbind.fillIn(res, v.asLogical(), offset, nrow, ast, ai);
            }
            return res;
        }
        if (hasRaw) {
            res = RRaw.RRawFactory.getUninitializedArray(size, ndim, null, null);
            for (ai = 0; ai < nargs; ++ai) {
                RAny v = args[ai];
                if (v instanceof RNull) continue;
                offset = Cbind.fillIn(res, v.asRaw(), offset, nrow, ast, ai);
            }
            return res;
        }
        return RNull.getNull();
    }
}

