/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Convert;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.ScalarStringImpl;
import r.data.internal.View;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

abstract class CharBase
extends CallFactory {
    CharBase(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    abstract String op(ASTNode var1, String var2);

    public RString convert(final ASTNode ast, final RString value) {
        final int size = value.size();
        if (value instanceof ScalarStringImpl) {
            return RString.RStringFactory.getScalar(this.op(ast, value.getString(0)), value.dimensions());
        }
        return new View.RStringProxy<RString>(value){

            @Override
            public int size() {
                return size;
            }

            @Override
            public String getString(int i) {
                return CharBase.this.op(ast, value.getString(i));
            }
        };
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        this.check(call, names, exprs);
        return new Builtin.Builtin1(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny value) {
                RString str = Convert.coerceToStringError(value, this.ast);
                return CharBase.this.convert(this.ast, str);
            }
        };
    }
}

