/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RSymbol;
import r.data.internal.DoubleImpl;
import r.data.internal.ScalarDoubleImpl;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Chol
extends CallFactory {
    static final CallFactory _ = new Chol("chol", new String[]{"x", "pivot", "LINPACK"}, new String[]{"x"});

    private Chol(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int xPosition = ia.position("x");
        final int pivotPosition = ia.position("pivot");
        final int linpackPosition = ia.position("LINPACK");
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                boolean linpack;
                int n;
                int[] dims;
                RDouble x;
                RAny xarg = args[xPosition];
                if (xarg instanceof RDouble || xarg instanceof RInt) {
                    x = xarg.asDouble().materialize();
                    if (!x.isTemporary()) {
                        x = RDouble.RDoubleFactory.copy(x);
                    }
                    if ((dims = x.dimensions()) != null && dims.length == 2) {
                        n = dims[0];
                        if (n != dims[1]) {
                            throw RError.getNonSquareMatrix(this.ast, "chol");
                        }
                    } else {
                        n = x.size();
                        if (n != 1) {
                            throw RError.getNonMatrix(this.ast, "chol");
                        }
                    }
                } else {
                    if (xarg instanceof RComplex) {
                        throw RError.getComplexNotPermitted(this.ast);
                    }
                    throw RError.getNonNumericArgumentTo(this.ast, "chol");
                }
                boolean pivot = pivotPosition == -1 ? false : CallFactory.parseUncheckedLogical(args[pivotPosition], this.ast);
                boolean bl = linpack = linpackPosition == -1 ? pivot : CallFactory.parseUncheckedLogical(args[linpackPosition], this.ast);
                if (!linpack) {
                    if (n == 0) {
                        throw RError.getDimsGTZero(this.ast, "x");
                    }
                    if (dims == null) {
                        if (x instanceof ScalarDoubleImpl) {
                            x = new DoubleImpl(new double[]{x.getDouble(0)}, RArray.SCALAR_DIMENSIONS, null, null, false);
                        } else {
                            x.setDimensions(RArray.SCALAR_DIMENSIONS);
                        }
                    }
                    double[] res = x.getContent();
                    for (int j = 0; j < n; ++j) {
                        for (int i = j + 1; i < n; ++i) {
                            res[i + j * n] = 0.0;
                        }
                    }
                    intW laINFO = new intW(0);
                    if (!pivot) {
                        LAPACK.getInstance().dpotrf("U", n, res, n, laINFO);
                        if (laINFO.val != 0) {
                            if (laINFO.val > 0) {
                                throw RError.getNotPositiveDefinite(this.ast, laINFO.val);
                            }
                            throw RError.getLapackInvalidValue(this.ast, laINFO.val, "dportf");
                        }
                        return x;
                    }
                    Utils.nyi("pivoting not implemented - need lapack routine dpstrf which is not available in netlib-java");
                    return null;
                }
                Utils.nyi("LINPACK version not implemented");
                return null;
            }
        };
    }
}

