/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

abstract class ColRowBase
extends CallFactory {
    ColRowBase(String name) {
        super(name, new String[]{"x", "na.rm", "dims"}, new String[]{"x"});
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        boolean xfirst;
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        if (ia.provided("dims")) {
            throw Utils.nyi("unimplemented argument");
        }
        if (names.length == 1) {
            return new Builtin.Builtin1(call, names, exprs){

                @Override
                public RAny doBuiltIn(Frame frame, RAny x) {
                    return ColRowBase.this.stat(this.ast, x, false);
                }
            };
        }
        boolean maybeNARm = false;
        if (ia.provided("na.rm") && !Builtin.isLogicalConstant(exprs[ia.position("na.rm")], 0)) {
            maybeNARm = true;
        }
        boolean bl = xfirst = ia.position("x") == 0;
        if (names.length == 2) {
            if (!maybeNARm) {
                return new Builtin.Builtin2(call, names, exprs){

                    @Override
                    public RAny doBuiltIn(Frame frame, RAny arg0, RAny arg1) {
                        return ColRowBase.this.stat(this.ast, xfirst ? arg0 : arg1, false);
                    }
                };
            }
            return new Builtin.Builtin2(call, names, exprs){

                @Override
                public RAny doBuiltIn(Frame frame, RAny arg0, RAny arg1) {
                    return xfirst ? ColRowBase.this.stat(this.ast, arg0, arg1) : ColRowBase.this.stat(this.ast, arg1, arg0);
                }
            };
        }
        throw Utils.nyi();
    }

    abstract double[] stat(RComplex var1, int var2, int var3, boolean var4);

    abstract double[] stat(RDouble var1, int var2, int var3, boolean var4);

    abstract double[] stat(RInt var1, int var2, int var3, boolean var4);

    abstract int[] getResultDimension(int[] var1);

    static int[] checkDimensions(ASTNode ast, int[] dimensions) {
        if (dimensions == null || dimensions.length < 2) {
            throw RError.getXArrayTwo(ast);
        }
        if (dimensions.length > 2) {
            int[] result = new int[]{dimensions[0], 1};
            for (int i = 1; i < dimensions.length; ++i) {
                result[1] = result[1] * dimensions[i];
            }
            return result;
        }
        return dimensions;
    }

    RAny stat(ASTNode ast, RComplex x, boolean naRM) {
        int[] dim = x.dimensions();
        int[] d = ColRowBase.checkDimensions(ast, dim);
        double[] content = this.stat(x, d[0], d[1], naRM);
        return RComplex.RComplexFactory.getFor(content, dim == d ? null : this.getResultDimension(dim), null);
    }

    RAny stat(ASTNode ast, RDouble x, boolean naRM) {
        int[] dim = x.dimensions();
        int[] d = ColRowBase.checkDimensions(ast, dim);
        double[] content = this.stat(x, d[0], d[1], naRM);
        return RDouble.RDoubleFactory.getFor(content, dim == d ? null : this.getResultDimension(dim), null);
    }

    RAny stat(ASTNode ast, RInt x, boolean naRM) {
        int[] dim = x.dimensions();
        int[] d = ColRowBase.checkDimensions(ast, dim);
        double[] content = this.stat(x, d[0], d[1], naRM);
        return RDouble.RDoubleFactory.getFor(content, dim == d ? null : this.getResultDimension(dim), null);
    }

    RAny stat(ASTNode ast, RAny x, boolean naRM) {
        if (x instanceof RDouble) {
            return this.stat(ast, (RDouble)x, naRM);
        }
        if (x instanceof RInt) {
            return this.stat(ast, (RInt)x, naRM);
        }
        if (x instanceof RLogical) {
            return this.stat(ast, x.asInt(), naRM);
        }
        if (x instanceof RComplex) {
            return this.stat(ast, (RComplex)x, naRM);
        }
        throw RError.getXNumeric(ast);
    }

    RAny stat(ASTNode ast, RAny x, RAny naRM) {
        if (naRM instanceof RLogical) {
            RLogical lnaRM = (RLogical)naRM;
            if (lnaRM.size() == 1) {
                int l = lnaRM.getLogical(0);
                if (l == 1) {
                    return this.stat(ast, x, true);
                }
                if (l == 0) {
                    return this.stat(ast, x, false);
                }
            }
        } else if (naRM instanceof RDouble || naRM instanceof RInt) {
            return this.stat(ast, x, naRM.asLogical());
        }
        throw RError.getInvalidArgument(ast, "na.rm");
    }

    static double[] colSumsMeans(RComplex c, int m, int n, boolean mean, boolean naRM) {
        double[] content = new double[2 * n];
        block0: for (int j = 0; j < n; ++j) {
            double sumreal = 0.0;
            double sumimag = 0.0;
            int excluded = 0;
            for (int i = 0; i < m; ++i) {
                double imag;
                int index = j * m + i;
                double real = c.getReal(index);
                if (!RComplex.RComplexUtils.eitherIsNAorNaN(real, imag = c.getImag(index))) {
                    sumreal += real;
                    sumimag += imag;
                    continue;
                }
                if (!naRM) {
                    content[2 * j] = RDouble.NA;
                    content[2 * j + 1] = RDouble.NA;
                    continue block0;
                }
                ++excluded;
            }
            if (mean) {
                double denom = m - excluded;
                content[2 * j] = sumreal / denom;
                content[2 * j + 1] = sumimag / denom;
                continue;
            }
            content[2 * j] = sumreal;
            content[2 * j + 1] = sumimag;
        }
        return content;
    }

    static double[] colSumsMeans(RDouble d, int m, int n, boolean mean, boolean naRM) {
        double[] content = new double[n];
        block0: for (int j = 0; j < n; ++j) {
            double sum = 0.0;
            int excluded = 0;
            for (int i = 0; i < m; ++i) {
                double v = d.getDouble(j * m + i);
                if (!RDouble.RDoubleUtils.isNAorNaN(v)) {
                    sum += v;
                    continue;
                }
                if (!naRM) {
                    content[j] = RDouble.NA;
                    continue block0;
                }
                ++excluded;
            }
            content[j] = mean ? sum / (double)(m - excluded) : sum;
        }
        return content;
    }

    static double[] colSumsMeans(RInt in, int m, int n, boolean mean, boolean naRM) {
        double[] content = new double[n];
        block0: for (int j = 0; j < n; ++j) {
            double sum = 0.0;
            int excluded = 0;
            for (int i = 0; i < m; ++i) {
                int v = in.getInt(j * m + i);
                if (v != Integer.MIN_VALUE) {
                    sum += (double)v;
                    continue;
                }
                if (!naRM) {
                    content[j] = RDouble.NA;
                    continue block0;
                }
                ++excluded;
            }
            content[j] = mean ? sum / (double)(m - excluded) : sum;
        }
        return content;
    }

    static double[] rowSumsMeans(RComplex c, int m, int n, boolean mean, boolean naRM) {
        double[] content = new double[2 * m];
        int[] excluded = null;
        boolean[] isNA = null;
        if (mean) {
            excluded = new int[m];
        }
        if (!naRM) {
            isNA = new boolean[m];
        }
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                double imag;
                int index = j * m + i;
                double real = c.getReal(index);
                if (!RComplex.RComplexUtils.eitherIsNAorNaN(real, imag = c.getImag(index))) {
                    int n2 = 2 * i;
                    content[n2] = content[n2] + real;
                    int n3 = 2 * i + 1;
                    content[n3] = content[n3] + imag;
                    continue;
                }
                if (!naRM) {
                    isNA[i] = true;
                    continue;
                }
                if (!mean) continue;
                int n4 = i;
                excluded[n4] = excluded[n4] + 1;
            }
        }
        if (!naRM || mean) {
            for (int i = 0; i < m; ++i) {
                if (!naRM) {
                    if (isNA[i]) {
                        content[2 * i] = RDouble.NA;
                        content[2 * i + 1] = RDouble.NA;
                        continue;
                    }
                    if (!mean) continue;
                    int n5 = 2 * i;
                    content[n5] = content[n5] / (double)n;
                    int n6 = 2 * i + 1;
                    content[n6] = content[n6] / (double)n;
                    continue;
                }
                if (!mean) continue;
                double denom = n - excluded[i];
                int n7 = 2 * i;
                content[n7] = content[n7] / denom;
                int n8 = 2 * i + 1;
                content[n8] = content[n8] / denom;
            }
        }
        return content;
    }

    static double[] rowSumsMeans(RDouble d, int m, int n, boolean mean, boolean naRM) {
        double[] content = new double[m];
        int[] excluded = null;
        boolean[] isNA = null;
        if (mean) {
            excluded = new int[m];
        }
        if (!naRM) {
            isNA = new boolean[m];
        }
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                double v = d.getDouble(j * m + i);
                if (!RDouble.RDoubleUtils.isNAorNaN(v)) {
                    int n2 = i;
                    content[n2] = content[n2] + v;
                    continue;
                }
                if (!naRM) {
                    isNA[i] = true;
                    continue;
                }
                if (!mean) continue;
                int n3 = i;
                excluded[n3] = excluded[n3] + 1;
            }
        }
        if (!naRM || mean) {
            for (int i = 0; i < m; ++i) {
                if (!naRM) {
                    if (isNA[i]) {
                        content[i] = RDouble.NA;
                        continue;
                    }
                    if (!mean) continue;
                    int n4 = i;
                    content[n4] = content[n4] / (double)n;
                    continue;
                }
                if (!mean) continue;
                int n5 = i;
                content[n5] = content[n5] / (double)(n - excluded[i]);
            }
        }
        return content;
    }

    static double[] rowSumsMeans(RInt in, int m, int n, boolean mean, boolean naRM) {
        double[] content = new double[m];
        int[] excluded = null;
        boolean[] isNA = null;
        if (mean) {
            excluded = new int[m];
        }
        if (!naRM) {
            isNA = new boolean[m];
        }
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                int v = in.getInt(j * m + i);
                if (v != Integer.MIN_VALUE) {
                    int n2 = i;
                    content[n2] = content[n2] + (double)v;
                    continue;
                }
                if (!naRM) {
                    isNA[i] = true;
                    continue;
                }
                if (!mean) continue;
                int n3 = i;
                excluded[n3] = excluded[n3] + 1;
            }
        }
        if (!naRM || mean) {
            for (int i = 0; i < m; ++i) {
                if (!naRM) {
                    if (isNA[i]) {
                        content[i] = RDouble.NA;
                        continue;
                    }
                    if (!mean) continue;
                    int n4 = i;
                    content[n4] = content[n4] / (double)n;
                    continue;
                }
                if (!mean) continue;
                int n5 = i;
                content[n5] = content[n5] / (double)(n - excluded[i]);
            }
        }
        return content;
    }
}

