/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.RContext;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Colon
extends CallFactory {
    static final CallFactory _ = new Colon(":", new String[]{"from", "to"}, null);

    Colon(String name, String[] parameters, String[] required) {
        super(name, parameters, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        this.check(call, names, exprs);
        return new Builtin.Builtin2(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny arg0, RAny arg1) {
                return Colon.generic(this.ast, arg0, arg1);
            }
        };
    }

    public static RAny createEager(int left, int right) {
        if (left <= right) {
            int len = right - left + 1;
            int[] data = new int[len];
            int val = left;
            for (int i = 0; i < len; ++i) {
                data[i] = val++;
            }
            return RInt.RIntFactory.getFor(data);
        }
        int len = left - right + 1;
        int[] data = new int[len];
        int val = left;
        for (int i = 0; i < len; ++i) {
            data[i] = val--;
        }
        return RInt.RIntFactory.getFor(data);
    }

    public static RAny create(int left, int right) {
        int step = left <= right ? 1 : -1;
        return RInt.RIntFactory.forSequence(left, right, step);
    }

    public static RAny create(double left, double right) {
        if (left <= right) {
            int len = (int)(right - left + 1.0);
            double[] data = new double[len];
            double val = left;
            for (int i = 0; i < len; ++i) {
                data[i] = val;
                val += 1.0;
            }
            return RDouble.RDoubleFactory.getFor(data);
        }
        int len = (int)(left - right + 1.0);
        double[] data = new double[len];
        double val = left;
        for (int i = 0; i < len; ++i) {
            data[i] = val;
            val -= 1.0;
        }
        return RDouble.RDoubleFactory.getFor(data);
    }

    public static void checkScalar(RArray a, ASTNode ast) {
        int n = a.size();
        if (n == 0) {
            throw RError.getLengthZero(ast);
        }
        if (n > 1) {
            RContext.warning(ast, String.format("numerical expression has %d elements: only the first used", n));
        }
    }

    public static void checkNAandNaN(double d, ASTNode ast) {
        if (RDouble.RDoubleUtils.isNAorNaN(d)) {
            throw RError.getNAorNaN(ast);
        }
    }

    public static void checkNA(int i, ASTNode ast) {
        if (i == Integer.MIN_VALUE) {
            throw RError.getNAorNaN(ast);
        }
    }

    public static RAny generic(ASTNode ast, RAny arg0, RAny arg1) {
        if (arg0 instanceof RInt) {
            RInt a0rint = (RInt)arg0;
            Colon.checkScalar(a0rint, ast);
            int a0 = a0rint.getInt(0);
            Colon.checkNA(a0, ast);
            if (arg1 instanceof RInt) {
                RInt a1rint = (RInt)arg1;
                Colon.checkScalar(a1rint, ast);
                int a1 = a1rint.getInt(0);
                Colon.checkNA(a1, ast);
                return Colon.create(a0, a1);
            }
            if (arg1 instanceof RDouble) {
                RDouble a1rdbl = (RDouble)arg1;
                Colon.checkScalar(a1rdbl, ast);
                double a1 = a1rdbl.getDouble(0);
                Colon.checkNAandNaN(a1, ast);
                if (RDouble.RDoubleUtils.fitsRInt(a1)) {
                    return Colon.create(a0, (int)a1);
                }
                return Colon.create((double)a0, a1);
            }
            if (arg1 instanceof RLogical) {
                RLogical a1rlog = (RLogical)arg1;
                Colon.checkScalar(a1rlog, ast);
                int a1 = a1rlog.getLogical(0);
                Colon.checkNA(a1, ast);
                return Colon.create(a0, a1);
            }
            throw Utils.nyi("unsupported argument type for colon operator");
        }
        if (arg0 instanceof RDouble) {
            RDouble a0rdbl = (RDouble)arg0;
            Colon.checkScalar(a0rdbl, ast);
            double a0 = a0rdbl.getDouble(0);
            Colon.checkNAandNaN(a0, ast);
            int ia0 = (int)a0;
            if ((double)ia0 == a0) {
                if (arg1 instanceof RInt) {
                    RInt a1rint = (RInt)arg1;
                    Colon.checkScalar(a1rint, ast);
                    int a1 = a1rint.getInt(0);
                    Colon.checkNA(a1, ast);
                    return Colon.create(ia0, a1);
                }
                if (arg1 instanceof RDouble) {
                    RDouble a1rdbl = (RDouble)arg1;
                    Colon.checkScalar(a1rdbl, ast);
                    double a1 = a1rdbl.getDouble(0);
                    Colon.checkNAandNaN(a1, ast);
                    if (RDouble.RDoubleUtils.fitsRInt(a1)) {
                        return Colon.create(ia0, (int)a1);
                    }
                    return Colon.create(a0, a1);
                }
                if (arg1 instanceof RLogical) {
                    RLogical a1rlog = (RLogical)arg1;
                    Colon.checkScalar(a1rlog, ast);
                    int a1 = a1rlog.getLogical(0);
                    Colon.checkNA(a1, ast);
                    return Colon.create(ia0, a1);
                }
                Utils.nyi("unsupported argument type for colon operator");
            } else {
                if (arg1 instanceof RDouble) {
                    RDouble a1rdbl = (RDouble)arg1;
                    Colon.checkScalar(a1rdbl, ast);
                    double a1 = a1rdbl.getDouble(0);
                    Colon.checkNAandNaN(a1, ast);
                    return Colon.create(a0, a1);
                }
                throw Utils.nyi("unsupported argument type for colon operator");
            }
        }
        if (arg0 instanceof RLogical) {
            return Colon.generic(ast, arg0.asInt(), arg1);
        }
        throw Utils.nyi("unsupported argument types for colon operator");
    }
}

