/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Console;
import r.RContext;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RLogical;
import r.data.RString;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class CommandArgs
extends CallFactory {
    static final CallFactory _ = new CommandArgs("commandArgs", new String[]{"trailingOnly"}, new String[0]);

    private CommandArgs(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        this.check(call, names, exprs);
        if (names.length == 0) {
            return new Builtin.Builtin0(call, names, exprs){

                @Override
                public RAny doBuiltIn(Frame frame) {
                    return RString.RStringFactory.getFor(Console.trailingArgs);
                }
            };
        }
        CommandArgs.ensureArgName(call, "trailingOnly", names[0]);
        return new Builtin.Builtin1(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny x) {
                int trailingOnly;
                RLogical l = x instanceof RLogical ? (RLogical)x : x.asLogical();
                int size = l.size();
                if (size == 0) {
                    throw RError.getLengthZero(this.ast);
                }
                if (size > 1) {
                    RContext.warning(this.ast, "the condition has length > 1 and only the first element will be used");
                }
                if ((trailingOnly = l.getLogical(0)) == 1) {
                    return RString.RStringFactory.getArray(Console.trailingArgs);
                }
                if (trailingOnly == 0) {
                    return RString.RStringFactory.getArray(Console.commandArgs);
                }
                throw RError.getUnexpectedNA(this.ast);
            }
        };
    }
}

