/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.RContext;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

public class Cor
extends CallFactory {
    static final CallFactory _ = new Cor("cor", new String[]{"x", "y", "use", "method"}, new String[]{"x"});
    static final CallFactory.ArgumentMatch methodMatch = new CallFactory.ArgumentMatch(new String[]{"pearson", "kendall", "spearman"});
    static final int M_PEARSON = 0;
    static final int M_KENDALL = 1;
    static final int M_SPEARMAN = 2;
    static final CallFactory.ArgumentMatch useMatch = new CallFactory.ArgumentMatch(new String[]{"all.obs", "complete.obs", "pairwise.complete.obs", "everything", "na.or.complete"});
    static final int M_ALL_OBS = 0;
    static final int M_COMPLETE_OBS = 1;
    static final int M_PAIRWISE_COMPLETE_OBS = 2;
    static final int M_EVERYTHING = 3;
    static final int M_NA_OR_COMPLETE = 4;

    private Cor(String name, String[] parameters, String[] required) {
        super(name, parameters, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        if (names.length == 1) {
            return new Builtin.Builtin1(call, names, exprs){

                @Override
                public RAny doBuiltIn(Frame frame, RAny xarg) {
                    if (!(xarg instanceof RDouble || xarg instanceof RInt || xarg instanceof RLogical)) {
                        if (xarg instanceof RArray) {
                            throw RError.getXNumeric(this.ast);
                        }
                        throw RError.getSupplyXYMatrix(this.ast);
                    }
                    RDouble xd = xarg.asDouble().materialize();
                    int[] dim = xd.dimensions();
                    if (dim == null || dim.length != 2) {
                        throw RError.getSupplyXYMatrix(this.ast);
                    }
                    int nrow = dim[0];
                    int ncol = dim[1];
                    double[] res = new double[ncol * ncol];
                    double[] x = xd.getContent();
                    boolean[] hasNA = new boolean[ncol];
                    boolean anyNA = Cor.columnsNAMap(x, nrow, ncol, hasNA);
                    int n1 = nrow - 1;
                    boolean sdZero = false;
                    if (!anyNA) {
                        int i;
                        double[] colMeans = Cor.columnMeansNoNA(x, nrow, ncol);
                        for (int i2 = 0; i2 < ncol; ++i2) {
                            double imean = colMeans[i2];
                            int ioffset = i2 * nrow;
                            for (int j = 0; j <= i2; ++j) {
                                double tmp;
                                double jmean = colMeans[j];
                                int joffset = j * nrow;
                                double sum = 0.0;
                                for (int k = 0; k < nrow; ++k) {
                                    sum += (x[ioffset + k] - imean) * (x[joffset + k] - jmean);
                                }
                                res[j * ncol + i2] = tmp = sum / (double)n1;
                                res[i2 * ncol + j] = tmp;
                            }
                        }
                        double[] srcov = colMeans;
                        for (i = 0; i < ncol; ++i) {
                            srcov[i] = Math.sqrt(res[i * ncol + i]);
                        }
                        for (i = 0; i < ncol; ++i) {
                            for (int j = 0; j < i; ++j) {
                                if (srcov[i] == 0.0 || srcov[j] == 0.0) {
                                    sdZero = true;
                                    res[j * ncol + i] = RDouble.NA;
                                    res[i * ncol + j] = RDouble.NA;
                                    continue;
                                }
                                double tmp = res[i * ncol + j] / (srcov[i] * srcov[j]);
                                if (tmp > 1.0) {
                                    tmp = 1.0;
                                }
                                res[j * ncol + i] = tmp;
                                res[i * ncol + j] = tmp;
                            }
                            res[i * ncol + i] = 1.0;
                        }
                    } else {
                        int i;
                        double[] colMeans = Cor.columnMeans(x, nrow, ncol, hasNA);
                        for (int i3 = 0; i3 < ncol; ++i3) {
                            if (hasNA[i3]) {
                                for (int j = 0; j <= i3; ++j) {
                                    res[j * ncol + i3] = RDouble.NA;
                                    res[i3 * ncol + j] = RDouble.NA;
                                }
                                continue;
                            }
                            double imean = colMeans[i3];
                            int ioffset = i3 * nrow;
                            for (int j = 0; j <= i3; ++j) {
                                double tmp;
                                if (hasNA[j]) {
                                    res[j * ncol + i3] = RDouble.NA;
                                    res[i3 * ncol + j] = RDouble.NA;
                                    continue;
                                }
                                double jmean = colMeans[j];
                                int joffset = j * nrow;
                                double sum = 0.0;
                                for (int k = 0; k < nrow; ++k) {
                                    sum += (x[ioffset + k] - imean) * (x[joffset + k] - jmean);
                                }
                                res[j * ncol + i3] = tmp = sum / (double)n1;
                                res[i3 * ncol + j] = tmp;
                            }
                        }
                        double[] srcov = colMeans;
                        for (i = 0; i < ncol; ++i) {
                            if (hasNA[i]) continue;
                            srcov[i] = Math.sqrt(res[i * ncol + i]);
                        }
                        for (i = 0; i < ncol; ++i) {
                            if (!hasNA[i]) {
                                for (int j = 0; j < i; ++j) {
                                    if (srcov[i] == 0.0 || srcov[j] == 0.0) {
                                        sdZero = true;
                                        res[j * ncol + i] = RDouble.NA;
                                        res[i * ncol + j] = RDouble.NA;
                                        continue;
                                    }
                                    double tmp = res[i * ncol + j] / (srcov[i] * srcov[j]);
                                    if (tmp > 1.0) {
                                        tmp = 1.0;
                                    }
                                    res[j * ncol + i] = tmp;
                                    res[i * ncol + j] = tmp;
                                }
                            }
                            res[i * ncol + i] = 1.0;
                        }
                    }
                    if (sdZero) {
                        RContext.warning(this.ast, "the standard deviation is zero");
                    }
                    return RDouble.RDoubleFactory.getFor(res, new int[]{ncol, ncol}, null);
                }
            };
        }
        Utils.nyi("finish cor");
        return null;
    }

    public static boolean columnsNAMap(double[] x, int nrow, int ncol, boolean[] hasNA) {
        boolean anyNA = false;
        block0: for (int j = 0; j < ncol; ++j) {
            int offset = j * nrow;
            for (int i = 0; i < nrow; ++i) {
                if (!RDouble.RDoubleUtils.isNAorNaN(x[offset + i])) continue;
                hasNA[j] = true;
                anyNA = true;
                continue block0;
            }
        }
        return anyNA;
    }

    public static double[] columnMeans(double[] x, int nrow, int ncol, boolean[] hasNA) {
        double[] res = new double[ncol];
        for (int j = 0; j < ncol; ++j) {
            if (hasNA[j]) {
                res[j] = RDouble.NA;
                continue;
            }
            int offset = j * nrow;
            double sum = 0.0;
            for (int k = 0; k < nrow; ++k) {
                sum += x[offset + k];
            }
            double tmp = sum / (double)nrow;
            if (RDouble.RDoubleUtils.isFinite(tmp)) {
                sum = 0.0;
                for (int k = 0; k < nrow; ++k) {
                    sum += x[offset + k] - tmp;
                }
                tmp += sum / (double)nrow;
            }
            res[j] = tmp;
        }
        return res;
    }

    public static double[] columnMeansNoNA(double[] x, int nrow, int ncol) {
        double[] res = new double[ncol];
        for (int j = 0; j < ncol; ++j) {
            int offset = j * nrow;
            double sum = 0.0;
            for (int k = 0; k < nrow; ++k) {
                sum += x[offset + k];
            }
            double tmp = sum / (double)nrow;
            if (RDouble.RDoubleUtils.isFinite(tmp)) {
                sum = 0.0;
                for (int k = 0; k < nrow; ++k) {
                    sum += x[offset + k] - tmp;
                }
                tmp += sum / (double)nrow;
            }
            res[j] = tmp;
        }
        return res;
    }
}

