/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import org.netlib.blas.BLAS;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RDouble;
import r.data.RNull;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.MatrixOperation;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Crossprod
extends CallFactory {
    static final CallFactory _ = new Crossprod("crossprod", new String[]{"x", "y"}, new String[]{"x"});

    private Crossprod(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int xpos = ia.position("x");
        int ypos = ia.position("y");
        if (ypos != -1) {
            return new Builtin.Builtin2(call, names, exprs){

                @Override
                public RAny doBuiltIn(Frame frame, RAny arg0, RAny arg1) {
                    RAny y;
                    RAny x;
                    if (xpos == 0) {
                        x = arg0;
                        y = arg1;
                    } else {
                        x = arg1;
                        y = arg0;
                    }
                    if (y instanceof RNull) {
                        return Crossprod.crossprod(x, this.ast);
                    }
                    return Crossprod.crossprod(x, y, this.ast);
                }
            };
        }
        return new Builtin.Builtin1(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny x) {
                return Crossprod.crossprod(x, this.ast);
            }
        };
    }

    public static RAny crossprod(RAny l, RAny r, ASTNode ast) {
        int rcol;
        int rrow;
        int lcol;
        int lrow;
        int nrdims;
        MatrixOperation.checkNumeric(l, r, ast);
        RDouble ld = l.asDouble().materialize();
        RDouble rd = r.asDouble().materialize();
        int[] ldims = ld.dimensions();
        int nldims = ldims == null ? 0 : ldims.length;
        int[] rdims = rd.dimensions();
        int n = nrdims = rdims == null ? 0 : rdims.length;
        if (nldims != 2) {
            if (nrdims != 2) {
                return MatrixOperation.dotProduct(ast, ld, rd);
            }
            lrow = ld.size();
            lcol = 1;
            rrow = rdims[0];
            rcol = rdims[1];
        } else {
            lrow = ldims[0];
            lcol = ldims[1];
            if (nrdims != 2) {
                rrow = rd.size();
                rcol = 1;
            } else {
                rrow = rdims[0];
                rcol = rdims[1];
            }
        }
        if (lrow != rrow) {
            throw RError.getNonConformableArgs(ast);
        }
        double[] res = Crossprod.matrixTimesMatrixNative(ld, rd, lcol, lrow, rcol);
        return RDouble.RDoubleFactory.getFor(res, new int[]{lcol, rcol}, null);
    }

    public static RAny crossprod(RAny x, ASTNode ast) {
        int ndims;
        MatrixOperation.checkNumeric(x, ast);
        RDouble xd = x.asDouble().materialize();
        int[] dims = xd.dimensions();
        int n = ndims = dims == null ? 0 : dims.length;
        if (ndims != 2) {
            return MatrixOperation.dotProduct(xd);
        }
        int row = dims[0];
        int col = dims[1];
        double[] res = Crossprod.matrixNative(xd, row, col);
        return RDouble.RDoubleFactory.getFor(res, new int[]{col, col}, null);
    }

    public static double[] matrixTimesMatrixNative(RDouble a, RDouble b, int m, int n, int p) {
        double[] res = new double[m * p];
        if (m > 0 && n > 0 && p > 0) {
            BLAS.getInstance().dgemm("T", "N", m, p, n, 1.0, a.getContent(), n, b.getContent(), n, 0.0, res, m);
        }
        return res;
    }

    public static double[] matrixNative(RDouble x, int row, int col) {
        double[] res = new double[col * col];
        if (row > 0 && col > 0) {
            BLAS.getInstance().dsyrk("U", "T", col, row, 1.0, x.getContent(), row, 0.0, res, col);
            for (int i = 0; i < col; ++i) {
                for (int j = 0; j < i; ++j) {
                    res[col * j + i] = res[col * i + j];
                }
            }
        }
        return res;
    }

    public static double[] matrixTimesMatrixGetters(RDouble a, RDouble b, int m, int n, int p) {
        double[] content = new double[m * p];
        for (int j = 0; j < p; ++j) {
            for (int i = 0; i < m; ++i) {
                double d = 0.0;
                for (int k = 0; k < n; ++k) {
                    d += a.getDouble(i * n + k) * b.getDouble(j * n + k);
                }
                content[j * m + i] = d;
            }
        }
        return content;
    }
}

