/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import java.util.Arrays;
import r.Convert;
import r.RContext;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RNull;
import r.data.RRaw;
import r.data.RString;
import r.data.RSymbol;
import r.nodes.ast.ASTNode;
import r.nodes.exec.Arithmetic;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Cumsum
extends CallFactory {
    static final CallFactory _ = new Cumsum("cumsum", new String[]{"x"}, null);

    private Cumsum(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    public static RComplex cumsum(RComplex x) {
        RComplex input = x.materialize();
        int size = x.size();
        double[] content = new double[2 * size];
        if (size > 0) {
            double raccum = 0.0;
            double iaccum = 0.0;
            for (int i = 0; i < size; ++i) {
                double imag;
                double real = input.getReal(i);
                if (RComplex.RComplexUtils.eitherIsNA(real, imag = input.getImag(i))) {
                    return Cumsum.finishComplexWithNAs(content, i);
                }
                content[2 * i] = raccum += real;
                content[2 * i + 1] = iaccum += imag;
            }
        }
        return RComplex.RComplexFactory.getFor(content);
    }

    public static RDouble cumsum(RDouble x) {
        RDouble input = x.materialize();
        int size = x.size();
        double[] content = new double[size];
        if (size > 0) {
            double accum = 0.0;
            for (int i = 0; i < size; ++i) {
                double value = input.getDouble(i);
                if (RDouble.RDoubleUtils.isNAorNaN(value)) {
                    return Cumsum.finishDoubleWithNAs(content, i);
                }
                content[i] = accum += value;
            }
        }
        return RDouble.RDoubleFactory.getFor(content);
    }

    private static RComplex finishComplexWithNAs(double[] content, int fromIndex) {
        Arrays.fill(content, 2 * fromIndex, content.length, RDouble.NA);
        return RComplex.RComplexFactory.getFor(content);
    }

    private static RDouble finishDoubleWithNAs(double[] content, int fromIndex) {
        Arrays.fill(content, fromIndex, content.length, RDouble.NA);
        return RDouble.RDoubleFactory.getFor(content);
    }

    public static RInt cumsum(RInt x, ASTNode ast) {
        RInt input = x.materialize();
        int size = x.size();
        int[] content = new int[size];
        if (size > 0) {
            int accum = 0;
            for (int i = 0; i < size; ++i) {
                int value = input.getInt(i);
                if (value == Integer.MIN_VALUE) {
                    return Cumsum.finishWithNAs(content, i);
                }
                if ((accum = Arithmetic.ADD.op(ast, accum, value)) == Integer.MIN_VALUE) {
                    RContext.warning(ast, "NAs produced by integer overflow");
                    return Cumsum.finishWithNAs(content, i);
                }
                content[i] = accum;
            }
        }
        return RInt.RIntFactory.getFor(content);
    }

    private static RInt finishWithNAs(int[] content, int fromIndex) {
        for (int i = fromIndex; i < content.length; ++i) {
            content[i] = Integer.MIN_VALUE;
        }
        return RInt.RIntFactory.getFor(content);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        this.check(call, names, exprs);
        return new Builtin.Builtin1(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny x) {
                if (x instanceof RDouble) {
                    RDouble dx = (RDouble)x;
                    return Cumsum.cumsum(dx).setNames(dx.names());
                }
                if (x instanceof RInt) {
                    RInt ix = (RInt)x;
                    return Cumsum.cumsum(ix, this.ast).setNames(ix.names());
                }
                if (x instanceof RLogical) {
                    RLogical lx = (RLogical)x;
                    return Cumsum.cumsum(lx.asInt(), this.ast).setNames(lx.names());
                }
                if (x instanceof RComplex) {
                    RComplex cx = (RComplex)x;
                    return Cumsum.cumsum(cx).setNames(cx.names());
                }
                if (x instanceof RRaw) {
                    RRaw rx = (RRaw)x;
                    return Cumsum.cumsum(rx.asDouble()).setNames(rx.names());
                }
                if (x instanceof RNull) {
                    return RDouble.EMPTY;
                }
                if (x instanceof RString) {
                    RString sx = (RString)x;
                    RDouble res = Cumsum.cumsum(Convert.coerceToDoubleWarning(sx, this.ast));
                    return res.setNames(sx.names());
                }
                throw Utils.nyi("unsupported type");
            }
        };
    }
}

