/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.builtins.CallFactory;
import r.builtins.EnvBase;
import r.data.REnvironment;
import r.data.RNull;
import r.data.RPromise;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.BaseR;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class DelayedAssign
extends CallFactory {
    static final CallFactory _ = new DelayedAssign("delayedAssign", new String[]{"x", "value", "eval.env", "assign.env"}, new String[]{"x", "value"});

    private DelayedAssign(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        int evalPos = ia.position("eval.env");
        int assignPos = ia.position("assign.env");
        return new Assign(call, exprs[ia.position("x")], exprs[ia.position("value")], evalPos == -1 ? null : exprs[evalPos], assignPos == -1 ? null : exprs[assignPos]);
    }

    public static class Assign
    extends BaseR {
        @RNode.Child
        RNode xNode;
        @RNode.Child
        RNode valueNode;
        @RNode.Child
        RNode evalEnvNode;
        @RNode.Child
        RNode assignEnvNode;

        public Assign(ASTNode ast, RNode xNode, RNode valueNode, RNode evalEnvNode, RNode assignEnvNode) {
            super(ast);
            this.xNode = this.adoptChild(xNode);
            this.valueNode = this.adoptChild(valueNode);
            this.evalEnvNode = this.adoptChild(evalEnvNode);
            this.assignEnvNode = this.adoptChild(assignEnvNode);
        }

        private REnvironment parseEnv(Frame frame, RNode envNode, String argName) {
            if (envNode == null) {
                return frame == null ? REnvironment.GLOBAL : frame.environment();
            }
            Object e = envNode.execute(frame);
            if (e instanceof REnvironment) {
                return (REnvironment)e;
            }
            throw RError.getInvalidArgument(this.ast, argName);
        }

        private Frame extractFrame(Frame frame, RNode envNode, String argName) {
            if (envNode == null) {
                return frame;
            }
            Object e = envNode.execute(frame);
            if (e instanceof REnvironment) {
                return ((REnvironment)e).frame();
            }
            throw RError.getInvalidArgument(this.ast, argName);
        }

        @Override
        public Object execute(Frame frame) {
            RSymbol xSymbol = EnvBase.parseXSilent(this.xNode.execute(frame), this.ast);
            Frame evalFrame = this.extractFrame(frame, this.evalEnvNode, "eval.env");
            REnvironment assignEnv = this.parseEnv(frame, this.assignEnvNode, "assign.env");
            assignEnv.delayedAssign(xSymbol, RPromise.createNormal(this.valueNode, evalFrame), this.ast);
            return RNull.getNull();
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            if (this.xNode == oldNode) {
                this.xNode = newNode;
                return this.adoptInternal(newNode);
            }
            if (this.valueNode == oldNode) {
                this.valueNode = newNode;
                return this.adoptInternal(newNode);
            }
            if (this.evalEnvNode == oldNode) {
                this.evalEnvNode = newNode;
                return this.adoptInternal(newNode);
            }
            if (this.assignEnvNode == oldNode) {
                this.assignEnvNode = newNode;
                return this.adoptInternal(newNode);
            }
            return super.replaceChild(oldNode, newNode);
        }
    }
}

