/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;
import r.Convert;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Det
extends CallFactory {
    static final CallFactory _ = new Det("det", new String[]{"x", "..."}, new String[]{"x"});

    private Det(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int xPosition = ia.position("x");
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                int i;
                RAny xarg = args[xPosition];
                if (!(xarg instanceof RArray)) {
                    throw RError.getInvalidArgument(this.ast, "x");
                }
                RArray xa = (RArray)xarg;
                int[] dims = xa.dimensions();
                if (dims == null || dims.length != 2) {
                    throw RError.getInvalidArgument(this.ast, "x");
                }
                int n = dims[0];
                if (n != dims[1]) {
                    throw RError.getMustBeSquare(this.ast, "x");
                }
                if (xarg instanceof RComplex) {
                    throw RError.getDeterminantComplex(this.ast);
                }
                RDouble x = Convert.coerceToDoubleError(xa, this.ast);
                double[] laA = RDouble.RDoubleUtils.copyAsDoubleArray(x);
                int[] laIPIV = new int[n];
                intW laINFO = new intW(0);
                LAPACK.getInstance().dgetrf(n, n, laA, n, laIPIV, laINFO);
                if (laINFO.val < 0) {
                    throw RError.getLapackError(this.ast, laINFO.val, "dgetrf");
                }
                if (laINFO.val > 0) {
                    return RDouble.BOXED_ZERO;
                }
                double res = 1.0;
                for (i = 0; i < n; ++i) {
                    if (laIPIV[i] == i + 1) continue;
                    res = -res;
                }
                for (i = 0; i < n; ++i) {
                    res *= laA[i * (n + 1)];
                }
                return RDouble.RDoubleFactory.getScalar(res);
            }
        };
    }
}

