/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RList;
import r.data.RLogical;
import r.data.RRaw;
import r.data.RString;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class DiagAssign
extends CallFactory {
    static final CallFactory _ = new DiagAssign("diag<-", new String[]{"x", "value"}, null);

    private DiagAssign(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        this.check(call, names, exprs);
        return new Builtin.Builtin2(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny x, RAny value) {
                RArray typedValue;
                RArray typedX;
                int rsize;
                if (!(x instanceof RArray)) {
                    throw RError.getOnlyMatrixDiagonals(this.ast);
                }
                RArray a = (RArray)x;
                int[] dim = a.dimensions();
                if (dim == null || dim.length != 2) {
                    throw RError.getOnlyMatrixDiagonals(this.ast);
                }
                int m = dim[0];
                int n = dim[1];
                int n2 = rsize = m < n ? m : n;
                if (x instanceof RList || value instanceof RList) {
                    typedX = x.asList();
                    typedValue = value.asList();
                } else if (x instanceof RString || value instanceof RString) {
                    typedX = x.asString();
                    typedValue = value.asString();
                } else if (x instanceof RComplex || value instanceof RComplex) {
                    typedX = x.asComplex();
                    typedValue = value.asComplex();
                } else if (x instanceof RDouble || value instanceof RDouble) {
                    typedX = x.asDouble();
                    typedValue = value.asDouble();
                } else if (x instanceof RInt || value instanceof RInt) {
                    typedX = x.asInt();
                    typedValue = value.asInt();
                } else if (x instanceof RLogical || value instanceof RLogical) {
                    typedX = x.asLogical();
                    typedValue = value.asLogical();
                } else if (x instanceof RRaw && value instanceof RRaw) {
                    typedX = (RRaw)x;
                    typedValue = (RRaw)value;
                } else {
                    throw Utils.nyi("unsupported types");
                }
                int vsize = typedValue.size();
                if (vsize != 1 && vsize != rsize) {
                    throw RError.getReplacementDiagonalLength(this.ast);
                }
                RArray res = Utils.createArray(typedX, m * n, dim, null, x.attributesRef());
                int vi = 0;
                for (int i = 0; i < m; ++i) {
                    for (int j = 0; j < n; ++j) {
                        int xindex = j * m + i;
                        if (i != j) {
                            res.set(xindex, typedX.getRef(xindex));
                            continue;
                        }
                        res.set(xindex, typedValue.getRef(vi++));
                        if (vi != vsize) continue;
                        vi = 0;
                    }
                }
                return res;
            }
        };
    }
}

