/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Convert;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RInt;
import r.data.RNull;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class DimAssign
extends CallFactory {
    static final CallFactory _ = new DimAssign("dim<-", new String[]{"x", "value"}, null);

    private DimAssign(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    static int[] buildDimensions(int size, RInt dims, ASTNode ast) {
        int dprod = 1;
        int dsize = dims.size();
        if (dsize == 0) {
            throw RError.getLengthZeroDimInvalid(ast);
        }
        int[] res = new int[dsize];
        for (int i = 0; i < dsize; ++i) {
            int d = dims.getInt(i);
            if (d >= 0) {
                dprod *= d;
            } else {
                if (d == Integer.MIN_VALUE) {
                    throw RError.getDimsContainNA(ast);
                }
                throw RError.getDimsContainNegativeValues(ast);
            }
            res[i] = d;
        }
        if (dprod != size) {
            throw RError.getDimsDontMatchLength(ast, dprod, size);
        }
        return res;
    }

    public static RArray replaceDims(RAny x, RAny value, ASTNode ast) {
        int[] dims;
        if (!(x instanceof RArray)) {
            throw RError.getInvalidFirstArgument(ast);
        }
        RArray a = (RArray)x;
        if (value instanceof RNull) {
            dims = null;
        } else {
            RInt ndims = Convert.coerceToIntWarning(value, ast);
            dims = DimAssign.buildDimensions(a.size(), ndims, ast);
        }
        if (!a.isShared()) {
            return a.setNames(null).setDimensions(dims);
        }
        return Utils.copyArray(a).setNames(null).setDimensions(dims);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        this.check(call, names, exprs);
        return new Builtin.Builtin2(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny x, RAny value) {
                return DimAssign.replaceDims(x, value, this.ast);
            }
        };
    }
}

