/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import java.util.Arrays;
import java.util.Comparator;
import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;
import r.Convert;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RList;
import r.data.RLogical;
import r.data.RNull;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Eigen
extends CallFactory {
    static final CallFactory _ = new Eigen("eigen", new String[]{"x", "symmetric", "only.values", "EISPACK"}, new String[]{"x"});
    public static final double tolerance = 100.0 * RDouble.EPSILON;

    private Eigen(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    public static boolean parseLogical(RAny arg, ASTNode ast, String argName) {
        RLogical larg = arg.asLogical();
        if (larg.size() >= 1) {
            int l = larg.getLogical(0);
            if (l == 1) {
                return true;
            }
            if (l == 0) {
                return false;
            }
        }
        throw RError.getInvalidArgument(ast, argName);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        if (ia.provided("EISPACK")) {
            throw Utils.nyi("EISPACK argument not supported");
        }
        final int posX = ia.position("x");
        final int posSymmetric = ia.position("symmetric");
        final int posOnlyvalue = ia.position("only.values");
        final RArray.Names resultNames = RArray.Names.create(RSymbol.getSymbols(new String[]{"values", "vectors"}));
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] params) {
                int[] dimNN;
                int n;
                double[] values;
                RArray x;
                RAny xany = params[posX];
                boolean complex = false;
                if (xany instanceof RDouble) {
                    x = (RDouble)xany;
                    values = RDouble.RDoubleUtils.copyAsDoubleArray((RDouble)xany);
                } else if (xany instanceof RComplex) {
                    complex = true;
                    x = (RComplex)xany;
                    values = RComplex.RComplexUtils.asDoubleArray((RComplex)xany);
                } else {
                    RDouble xd = Convert.coerceToDoubleError(xany, this.ast);
                    values = RDouble.RDoubleUtils.copyAsDoubleArray(xd);
                    x = xd;
                }
                int[] dim = x.dimensions();
                int size = x.size();
                if (dim == null || dim.length != 2) {
                    if (size == 0) {
                        throw RError.getInvalidArgument(this.ast, "x");
                    }
                    if (size != 1) {
                        throw RError.getNonSquareMatrix(this.ast, "eigen");
                    }
                    n = 1;
                    dimNN = RArray.SCALAR_DIMENSIONS;
                } else {
                    n = dim[0];
                    if (dim[1] != n) {
                        throw RError.getNonSquareMatrix(this.ast, "x");
                    }
                    dimNN = dim;
                }
                for (int i = 0; i < values.length; ++i) {
                    if (RDouble.RDoubleUtils.isFinite(values[i])) continue;
                    throw RError.getInfiniteMissingValues(this.ast, "x");
                }
                boolean symmetric = posSymmetric != -1 ? Eigen.parseLogical(params[posSymmetric], this.ast, "symmetric") : (complex ? Eigen.isSymmetricComplex(values, n) : Eigen.isSymmetricDouble(values, n));
                boolean onlyValues = posOnlyvalue != -1 ? Eigen.parseLogical(params[posOnlyvalue], this.ast, "only.values") : false;
                RArray resValues = RNull.getNull();
                RArray resVectors = RNull.getNull();
                if (!complex) {
                    if (symmetric) {
                        double[] laZ;
                        String laJOBZ;
                        if (onlyValues) {
                            laJOBZ = "N";
                            laZ = null;
                        } else {
                            laJOBZ = "V";
                            laZ = new double[size];
                        }
                        int[] laISUPPZ = new int[2 * n];
                        intW laM = new intW(0);
                        double[] laW = new double[n];
                        intW laINFO = new intW(0);
                        double[] laWORK = new double[1];
                        int[] laIWORK = new int[1];
                        LAPACK.getInstance().dsyevr(laJOBZ, "A", "L", n, values, n, 0.0, 0.0, 0, 0, 0.0, laM, laW, laZ, n, laISUPPZ, laWORK, -1, laIWORK, -1, laINFO);
                        if (laINFO.val != 0) {
                            throw RError.getLapackError(this.ast, laINFO.val, "dsyevr");
                        }
                        int laLWORK = (int)laWORK[0];
                        int laLIWORK = laIWORK[0];
                        laWORK = new double[laLWORK];
                        laIWORK = new int[laLIWORK];
                        LAPACK.getInstance().dsyevr(laJOBZ, "A", "L", n, values, n, 0.0, 0.0, 0, 0, 0.0, laM, laW, laZ, n, laISUPPZ, laWORK, laLWORK, laIWORK, laLIWORK, laINFO);
                        if (laINFO.val != 0) {
                            throw RError.getLapackError(this.ast, laINFO.val, "dsyevr");
                        }
                        resValues = RDouble.RDoubleFactory.getFor(Utils.reverse(laW));
                        if (!onlyValues) {
                            resVectors = RDouble.RDoubleFactory.getFor(Eigen.reverseColumns(laZ, n, n), dimNN, null);
                        }
                    } else {
                        double[] laVR;
                        String laJOBVR;
                        if (onlyValues) {
                            laJOBVR = "N";
                            laVR = null;
                        } else {
                            laJOBVR = "V";
                            laVR = new double[size];
                        }
                        double[] laWR = new double[n];
                        double[] laWI = new double[n];
                        intW laINFO = new intW(0);
                        double[] laWORK = new double[1];
                        LAPACK.getInstance().dgeev("N", laJOBVR, n, values, n, laWR, laWI, null, n, laVR, n, laWORK, -1, laINFO);
                        if (laINFO.val != 0) {
                            throw RError.getLapackError(this.ast, laINFO.val, "dgeev");
                        }
                        int laLWORK = (int)laWORK[0];
                        laWORK = new double[laLWORK];
                        LAPACK.getInstance().dgeev("N", laJOBVR, n, values, n, laWR, laWI, null, n, laVR, n, laWORK, laLWORK, laINFO);
                        if (laINFO.val != 0) {
                            throw RError.getLapackError(this.ast, laINFO.val, "dgeev");
                        }
                        boolean returnComplex = false;
                        for (int i = 0; i < n; ++i) {
                            if (!(Math.abs(laWI[i]) > 10.0 * RDouble.EPSILON * Math.abs(laWR[i]))) continue;
                            returnComplex = true;
                            break;
                        }
                        if (returnComplex) {
                            Integer[] order = Eigen.decreasingModOrder(laWR, laWI, n);
                            resValues = RComplex.RComplexFactory.getArray(Eigen.reorder(laWR, order, n), Eigen.reorder(laWI, order, n), null);
                            if (!onlyValues) {
                                resVectors = RComplex.RComplexFactory.getFor(Eigen.unscrambleComplexEigenVectors(laWI, laVR, n), dimNN, null);
                            }
                        } else {
                            Integer[] order = Eigen.decreasingAbsOrder(laWR, n);
                            resValues = RDouble.RDoubleFactory.getFor(Eigen.reorder(laWR, order, n));
                            if (!onlyValues) {
                                resVectors = RDouble.RDoubleFactory.getMatrixFor(Eigen.reorderColumns(laVR, order, n, n), n, n);
                            }
                        }
                    }
                } else {
                    if (symmetric) {
                        throw Utils.nyi("ZHEEV not supported by netlib-java");
                    }
                    throw Utils.nyi("ZGEEV not supported by netlib-java");
                }
                return RList.RListFactory.getFor(new RAny[]{resValues, resVectors}, null, resultNames);
            }
        };
    }

    public static boolean isSymmetricDouble(double[] values, int n) {
        assert (Utils.check(values.length == n * n));
        int size = values.length;
        double sumAbsTarget = 0.0;
        for (int i = 0; i < size; ++i) {
            sumAbsTarget += Math.abs(values[i]);
        }
        double sumAbsDiff = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double target = values[j * n + i];
                double current = values[i * n + j];
                sumAbsDiff += Math.abs(target - current);
            }
        }
        double meanAbsTarget = sumAbsTarget / (double)size;
        double metric = RDouble.RDoubleUtils.isFinite(meanAbsTarget) && meanAbsTarget > tolerance ? sumAbsDiff / sumAbsTarget : sumAbsDiff;
        return metric <= tolerance;
    }

    public static boolean isSymmetricComplex(double[] values, int n) {
        assert (Utils.check(values.length == n * n * 2));
        int size = values.length;
        double sumAbsTarget = 0.0;
        int i = 0;
        while (i < size) {
            double real = values[i++];
            double imag = values[i++];
            sumAbsTarget += Math.sqrt(real * real + imag * imag);
        }
        double sumAbsDiff = 0.0;
        for (i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                int targetIndex = j * n + i;
                int currentIndex = i * n + j;
                double real = values[2 * targetIndex] - values[2 * currentIndex];
                double imag = values[2 * targetIndex + 1] + values[2 * currentIndex + 1];
                sumAbsDiff += Math.sqrt(real * real + imag * imag);
            }
        }
        double meanAbsTarget = sumAbsTarget / (double)size;
        double metric = RDouble.RDoubleUtils.isFinite(meanAbsTarget) && meanAbsTarget > tolerance ? sumAbsDiff / sumAbsTarget : sumAbsDiff;
        return metric <= tolerance;
    }

    public static double[] unscrambleComplexEigenVectors(double[] valuesImag, double[] scrambledVectors, int n) {
        assert (Utils.check(valuesImag.length == n));
        assert (Utils.check(scrambledVectors.length == n * n));
        int rawsize = 2 * n * n;
        double[] content = new double[rawsize];
        int j = 0;
        while (j < n) {
            int offset;
            int i;
            if (valuesImag[j] != 0.0) {
                for (i = 0; i < n; ++i) {
                    double imag;
                    double real;
                    offset = j * n + i;
                    int nextOffset = offset + n;
                    content[2 * offset] = real = scrambledVectors[offset];
                    content[2 * nextOffset] = real;
                    content[2 * offset + 1] = imag = scrambledVectors[nextOffset];
                    content[2 * nextOffset + 1] = -imag;
                }
                j += 2;
                continue;
            }
            for (i = 0; i < n; ++i) {
                offset = j * n + i;
                content[2 * offset] = scrambledVectors[offset];
            }
            ++j;
        }
        return content;
    }

    public static double[] reverseColumns(double[] x, int m, int n) {
        assert (Utils.check(x.length == m * n));
        for (int j = 0; j < n / 2; ++j) {
            int colOffset1 = j * m;
            int colOffset2 = (n - 1 - j) * m;
            for (int i = 0; i < m; ++i) {
                double tmp = x[i + colOffset1];
                x[i + colOffset1] = x[i + colOffset2];
                x[i + colOffset2] = tmp;
            }
        }
        return x;
    }

    public static Integer[] decreasingModOrder(double[] real, double[] imag, int n) {
        assert (Utils.check(real.length == n));
        assert (Utils.check(imag.length == n));
        final double[] mod = new double[n];
        for (int i = 0; i < n; ++i) {
            double re = real[i];
            double im = imag[i];
            mod[i] = re * re + im * im;
        }
        Integer[] order = new Integer[n];
        for (int i = 0; i < n; ++i) {
            order[i] = i;
        }
        Arrays.sort(order, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return Double.compare(mod[o2], mod[o1]);
            }
        });
        return order;
    }

    public static Integer[] decreasingAbsOrder(final double[] real, int n) {
        Integer[] order = new Integer[n];
        for (int i = 0; i < n; ++i) {
            order[i] = i;
        }
        Arrays.sort(order, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return Double.compare(Math.abs(real[o2]), Math.abs(real[o1]));
            }
        });
        return order;
    }

    public static double[] reorder(double[] x, Integer[] order, int n) {
        assert (Utils.check(x.length == n));
        assert (Utils.check(order.length == n));
        double[] res = new double[n];
        for (int i = 0; i < n; ++i) {
            res[order[i].intValue()] = x[i];
        }
        return res;
    }

    public static double[] reorderColumns(double[] x, Integer[] order, int m, int n) {
        assert (Utils.check(x.length == m * n));
        assert (Utils.check(order.length == m));
        double[] res = new double[m * n];
        for (int j = 0; j < m; ++j) {
            int srcOffset = j * m;
            int dstOffset = order[j] * m;
            System.arraycopy(x, srcOffset, res, dstOffset, n);
        }
        return res;
    }
}

