/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.RContext;
import r.Utils;
import r.data.RAny;
import r.data.RDouble;
import r.data.REnvironment;
import r.data.RInt;
import r.data.RLogical;
import r.data.RString;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.runtime.Frame;

final class EnvBase {
    EnvBase() {
    }

    static RSymbol parseX(RAny arg, ASTNode ast) {
        RString sarg;
        int size;
        if (arg instanceof RString && (size = (sarg = (RString)arg).size()) > 0) {
            String s = sarg.getString(0);
            if (size > 1) {
                RContext.warning(ast, "only the first element is used as variable name");
            }
            return RSymbol.getSymbol(s);
        }
        throw RError.getInvalidFirstArgument(ast);
    }

    static boolean parseInherits(RAny arg, ASTNode ast) {
        RLogical larg = arg.asLogical();
        if (larg.size() == 0) {
            throw RError.getInvalidArgument(ast, "inherits");
        }
        int v = larg.getLogical(0);
        if (v != Integer.MIN_VALUE) {
            return v == 1;
        }
        throw RError.getInvalidArgument(ast, "inherits");
    }

    static REnvironment parseEnvir(Object arg, ASTNode ast) {
        if (arg instanceof REnvironment) {
            return (REnvironment)arg;
        }
        throw RError.getInvalidArgument(ast, "envir");
    }

    static REnvironment extractEnvironment(RAny envir, RAny pos, Frame frame, ASTNode ast) {
        if (envir != null) {
            return EnvBase.parseEnvir(envir, ast);
        }
        if (pos != null) {
            return EnvBase.asEnvironment(frame, ast, pos, true);
        }
        return frame == null ? REnvironment.GLOBAL : frame.environment();
    }

    static RSymbol parseXSilent(Object arg, ASTNode ast) {
        if (!(arg instanceof RString)) {
            throw RError.getInvalidFirstArgument(ast);
        }
        RString sarg = (RString)arg;
        if (sarg.size() == 0) {
            throw RError.getInvalidFirstArgument(ast);
        }
        return RSymbol.getSymbol(sarg.getString(0));
    }

    static REnvironment asEnvironment(Frame frame, ASTNode ast, RAny arg) {
        return EnvBase.asEnvironment(frame, ast, arg, false);
    }

    static REnvironment asEnvironment(Frame frame, ASTNode ast, RAny arg, boolean fakePromise) {
        if (arg instanceof REnvironment) {
            return (REnvironment)arg;
        }
        if (!(arg instanceof RInt) && !(arg instanceof RDouble)) {
            throw RError.getInvalidArgument(ast, "pos");
        }
        RInt iarg = arg.asInt();
        int size = iarg.size();
        if (size == 0) {
            throw RError.getInvalidArgument(ast, "pos");
        }
        if (size == 1) {
            int idx = iarg.getInt(0);
            if (idx == -1) {
                if (frame != null) {
                    if (fakePromise) {
                        return frame.environment();
                    }
                    Frame enclosingFrame = frame.enclosingFrame();
                    return enclosingFrame == null ? REnvironment.GLOBAL : enclosingFrame.environment();
                }
                if (fakePromise) {
                    return REnvironment.GLOBAL;
                }
                throw RError.getNoEnclosingEnvironment(ast);
            }
            if (idx == 1) {
                return REnvironment.GLOBAL;
            }
        }
        if (size > 1) {
            throw Utils.nyi("create a list...");
        }
        throw RError.getInvalidArgument(ast, "pos");
    }
}

