/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.RContext;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RDouble;
import r.data.REnvironment;
import r.data.RFunction;
import r.data.RInt;
import r.data.RLanguage;
import r.data.RList;
import r.data.RNull;
import r.data.RSymbol;
import r.data.internal.EnvironmentImpl;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.ast.SimpleAccessVariable;
import r.nodes.exec.RNode;
import r.runtime.Frame;

public class Eval
extends CallFactory {
    static final CallFactory _ = new Eval("eval", new String[]{"expr", "envir", "enclos"}, new String[]{"expr"});

    private Eval(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int posExpr = ia.position("expr");
        final int posEnvir = ia.position("envir");
        final int posEnclos = ia.position("enclos");
        return new Builtin(call, names, exprs){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                RFunction rootEnclosingFunction;
                ASTNode exprAST;
                RAny exprArg;
                Frame targetFrame = frame;
                if (posEnvir != -1) {
                    RAny envirArg = args[posEnvir];
                    if (envirArg instanceof RList) {
                        Frame parentFrame;
                        if (posEnclos == -1) {
                            parentFrame = frame;
                        } else {
                            RAny enclosArg = args[posEnclos];
                            if (enclosArg instanceof RNull) {
                                parentFrame = null;
                            } else {
                                if (!(enclosArg instanceof REnvironment)) throw RError.getInvalidArgument(this.ast, "enclos");
                                parentFrame = ((REnvironment)enclosArg).frame();
                            }
                        }
                        targetFrame = EnvironmentImpl.Custom.createForList(parentFrame, (RList)envirArg);
                    } else if (envirArg instanceof REnvironment) {
                        targetFrame = ((REnvironment)envirArg).frame();
                    } else if (envirArg instanceof RNull) {
                        if (posEnclos == -1) {
                            targetFrame = frame;
                        } else {
                            RAny enclosArg = args[posEnclos];
                            if (enclosArg instanceof RNull) {
                                targetFrame = null;
                            } else {
                                if (!(enclosArg instanceof REnvironment)) throw RError.getInvalidArgument(this.ast, "enclos");
                                targetFrame = ((REnvironment)enclosArg).frame();
                            }
                        }
                    } else {
                        if (!(envirArg instanceof RInt) && !(envirArg instanceof RDouble)) throw RError.getInvalidArgument(this.ast, "envir");
                        RInt ienv = envirArg.asInt();
                        if (ienv.size() != 1) {
                            throw RError.getEnvirNotLengthOne(this.ast);
                        }
                        int i = ienv.getInt(0);
                        if (i == 0) {
                            targetFrame = EnvironmentImpl.Custom.create(null, new EnvironmentImpl.Empty(), false, 0).frame();
                        } else if (i == -1) {
                            targetFrame = frame;
                        } else {
                            Utils.nyi();
                        }
                    }
                }
                if ((exprArg = args[posExpr]) instanceof RLanguage) {
                    exprAST = ((RLanguage)exprArg).get();
                    rootEnclosingFunction = targetFrame == null ? null : targetFrame.function();
                    return (RAny)RContext.createRootNode(exprAST, rootEnclosingFunction).execute(targetFrame);
                }
                if (!(exprArg instanceof RSymbol)) return exprArg;
                exprAST = new SimpleAccessVariable((RSymbol)exprArg);
                rootEnclosingFunction = targetFrame == null ? null : targetFrame.function();
                return (RAny)RContext.createRootNode(exprAST, rootEnclosingFunction).execute(targetFrame);
            }
        };
    }
}

