/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.builtins.EnvBase;
import r.data.RAny;
import r.data.REnvironment;
import r.data.RLogical;
import r.data.RSymbol;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Exists
extends CallFactory {
    static final CallFactory _ = new Exists("exists", new String[]{"x", "where", "envir", "frame", "mode", "inherits"}, new String[]{"x"});
    private static final boolean DEFAULT_INHERITS = true;

    private Exists(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        if (ia.provided("frame")) {
            throw Utils.nyi("frame");
        }
        if (ia.provided("mode")) {
            throw Utils.nyi("mode");
        }
        final int posX = ia.position("x");
        final int posEnvir = ia.position("envir");
        final int posWhere = ia.position("where");
        final int posInherits = ia.position("inherits");
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                boolean inherits;
                RAny posArg;
                RSymbol nm = EnvBase.parseXSilent(args[posX], this.ast);
                RAny envirArg = posEnvir != -1 ? args[posEnvir] : null;
                REnvironment envir = EnvBase.extractEnvironment(envirArg, posArg = posWhere != -1 ? args[posWhere] : null, frame, this.ast);
                boolean res = envir.exists(nm, inherits = posInherits != -1 ? EnvBase.parseInherits(args[posInherits], this.ast) : true);
                if (res) {
                    return RLogical.BOXED_TRUE;
                }
                return RLogical.BOXED_FALSE;
            }
        };
    }
}

