/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.RContext;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RSymbol;
import r.data.internal.View;
import r.errors.RError;
import r.gnur.GNUR;
import r.nodes.ast.ASTNode;
import r.nodes.exec.Arithmetic;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Exp
extends CallFactory {
    static final CallFactory _ = new Exp("exp", new String[]{"x"}, new String[]{"x"});

    private Exp(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        this.check(call, names, exprs);
        return new Builtin.Builtin1(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny arg) {
                if (arg instanceof RDouble || arg instanceof RInt || arg instanceof RLogical) {
                    return new View.RDoubleProxy<RDouble>(arg.asDouble()){

                        @Override
                        public double getDouble(int i) {
                            double d = ((RDouble)this.orig).getDouble(i);
                            if (RDouble.RDoubleUtils.isNAorNaN(d)) {
                                return RDouble.NA;
                            }
                            double res = RContext.hasGNUR() ? GNUR.exp(d) : Math.exp(d);
                            if (RDouble.RDoubleUtils.isNAorNaN(res)) {
                                RContext.warning(ast, "NaNs produced");
                            }
                            return res;
                        }
                    };
                }
                if (arg instanceof RComplex) {
                    return Arithmetic.ComplexView.create(RComplex.BOXED_E, (RComplex)arg, Arithmetic.POW, this.ast);
                }
                throw RError.getNonNumericMath(this.ast);
            }
        };
    }
}

