/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Convert;
import r.RContext;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RString;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

abstract class ExtremeBase
extends CallFactory {
    ExtremeBase(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    abstract int extreme(int var1, int var2);

    abstract double extreme(double var1, double var3);

    abstract String extreme(String var1, String var2);

    abstract RAny emptySetExtreme();

    public RAny extreme(RString arg, ASTNode ast) {
        int size = arg.size();
        if (size == 0) {
            RContext.warning(ast, "no non-missing arguments to max; returning -Inf");
            return this.emptySetExtreme();
        }
        String res = arg.getString(0);
        for (int i = 1; i < size; ++i) {
            String s = arg.getString(i);
            if (s == RString.NA) {
                return RString.BOXED_NA;
            }
            res = this.extreme(s, res);
        }
        return RString.RStringFactory.getScalar(res);
    }

    public RAny extreme(RDouble arg, ASTNode ast) {
        int size = arg.size();
        if (size == 0) {
            RContext.warning(ast, "no non-missing arguments to max; returning -Inf");
            return this.emptySetExtreme();
        }
        double res = arg.getDouble(0);
        for (int i = 1; i < size; ++i) {
            double d = arg.getDouble(i);
            res = this.extreme(d, res);
            if (!RDouble.RDoubleUtils.arithIsNA(d)) continue;
            return RDouble.BOXED_NA;
        }
        return RDouble.RDoubleFactory.getScalar(res);
    }

    public RAny extreme(RInt arg, ASTNode ast) {
        int size = arg.size();
        if (size == 0) {
            RContext.warning(ast, "no non-missing arguments to max; returning -Inf");
            return this.emptySetExtreme();
        }
        int res = arg.getInt(0);
        for (int i = 1; i < size; ++i) {
            int v = arg.getInt(i);
            res = this.extreme(v, res);
            if (v != Integer.MIN_VALUE) continue;
            return RInt.BOXED_NA;
        }
        return RInt.RIntFactory.getScalar(res);
    }

    public RAny extreme(RLogical arg, ASTNode ast) {
        int size = arg.size();
        if (size == 0) {
            RContext.warning(ast, "no non-missing arguments to max; returning -Inf");
            return this.emptySetExtreme();
        }
        int res = arg.getLogical(0);
        for (int i = 1; i < size; ++i) {
            int v = arg.getLogical(i);
            if (v > res) {
                res = v;
            }
            if (v != Integer.MIN_VALUE) continue;
            return RInt.BOXED_NA;
        }
        return RInt.RIntFactory.getScalar(res);
    }

    public RAny extreme(RAny arg, ASTNode ast) {
        if (arg instanceof RDouble) {
            return this.extreme((RDouble)arg, ast);
        }
        if (arg instanceof RInt) {
            return this.extreme((RInt)arg, ast);
        }
        if (arg instanceof RLogical) {
            return this.extreme((RLogical)arg, ast);
        }
        if (arg instanceof RString) {
            return this.extreme((RString)arg, ast);
        }
        throw RError.getInvalidTypeArgument(ast, arg.typeOf());
    }

    public RAny extreme(RAny scalar0, RAny scalar1) {
        if (scalar0 instanceof RDouble) {
            if (scalar1 instanceof RDouble) {
                return RDouble.RDoubleFactory.getScalar(this.extreme(((RDouble)scalar0).getDouble(0), ((RDouble)scalar1).getDouble(0)));
            }
            if (scalar1 instanceof RInt) {
                return RDouble.RDoubleFactory.getScalar(this.extreme(((RDouble)scalar0).getDouble(0), Convert.int2double(((RInt)scalar1).getInt(0))));
            }
            return RString.RStringFactory.getScalar(this.extreme(Convert.double2string(((RDouble)scalar0).getDouble(0)), ((RString)scalar1).getString(0)));
        }
        if (scalar0 instanceof RInt) {
            if (scalar1 instanceof RDouble) {
                return RDouble.RDoubleFactory.getScalar(this.extreme(Convert.int2double(((RInt)scalar0).getInt(0)), ((RDouble)scalar1).getDouble(0)));
            }
            if (scalar1 instanceof RInt) {
                return RInt.RIntFactory.getScalar(this.extreme(((RInt)scalar0).getInt(0), ((RInt)scalar1).getInt(0)));
            }
            return RString.RStringFactory.getScalar(this.extreme(Convert.int2string(((RInt)scalar0).getInt(0)), ((RString)scalar1).getString(0)));
        }
        if (scalar1 instanceof RDouble) {
            return RString.RStringFactory.getScalar(this.extreme(((RString)scalar0).getString(0), Convert.double2string(((RDouble)scalar1).getDouble(0))));
        }
        if (scalar1 instanceof RInt) {
            return RString.RStringFactory.getScalar(this.extreme(((RString)scalar0).getString(0), Convert.int2string(((RInt)scalar1).getInt(0))));
        }
        return RString.RStringFactory.getScalar(this.extreme(((RString)scalar0).getString(0), ((RString)scalar1).getString(0)));
    }

    public RAny extreme(RAny[] args, ASTNode ast) {
        int size = args.length;
        RAny res = this.extreme(args[0], ast);
        for (int i = 1; i < size; ++i) {
            res = this.extreme(res, this.extreme(args[i], ast));
        }
        return res;
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        this.check(call, names, exprs);
        if (exprs.length == 0) {
            return new Builtin.Builtin0(call, names, exprs){

                @Override
                public RAny doBuiltIn(Frame frame) {
                    RContext.warning(this.ast, "no non-missing arguments to max; returning -Inf");
                    return ExtremeBase.this.emptySetExtreme();
                }
            };
        }
        if (exprs.length == 1) {
            return new Builtin.Builtin1(call, names, exprs){

                @Override
                public RAny doBuiltIn(Frame frame, RAny arg) {
                    return ExtremeBase.this.extreme(arg, this.ast);
                }
            };
        }
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                return ExtremeBase.this.extreme(args, this.ast);
            }
        };
    }
}

