/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RSymbol;
import r.errors.RError;
import r.gnur.GNUR;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Fft
extends CallFactory {
    static final CallFactory _ = new Fft("fft", new String[]{"z", "inverse"}, new String[]{"z"});

    private Fft(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    public static boolean parseInverse(RAny arg) {
        RLogical l = arg.asLogical();
        return l.getLogical(0) == 1;
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int zPosition = ia.position("z");
        final int inversePosition = ia.position("inverse");
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                RComplex res;
                RAny zarg = args[zPosition];
                if (zarg instanceof RDouble || zarg instanceof RInt || zarg instanceof RLogical) {
                    res = zarg.asComplex().materialize();
                } else if (zarg instanceof RComplex) {
                    res = zarg.isTemporary() ? (RComplex)zarg : RComplex.RComplexFactory.copy((RComplex)zarg);
                } else {
                    throw RError.getNonNumericArgument(this.ast);
                }
                if (res.size() <= 1) {
                    return res;
                }
                double[] z = res.getContent();
                boolean inverse = inversePosition == -1 ? false : Fft.parseInverse(args[inversePosition]);
                int ap_inv = inverse ? 2 : -2;
                int[] ap_maxf = new int[1];
                int[] ap_maxp = new int[1];
                int[] dims = res.dimensions();
                if (dims == null) {
                    int n = res.size();
                    GNUR.fft_factor(n, ap_maxf, ap_maxp);
                    int maxp = ap_maxp[0];
                    int maxf = ap_maxf[0];
                    if (maxf == 0) {
                        throw RError.getFFTFactorization(this.ast);
                    }
                    double[] ap_work = new double[4 * maxf];
                    int[] ap_iwork = new int[maxp];
                    GNUR.fft_work(z, 1, n, 1, ap_inv, ap_work, ap_iwork);
                    return res;
                }
                int maxmaxf = 1;
                int maxmaxp = 1;
                int ndims = dims.length;
                for (int i = 0; i < ndims; ++i) {
                    int d = dims[i];
                    if (d <= 1) continue;
                    GNUR.fft_factor(d, ap_maxf, ap_maxp);
                    int maxp = ap_maxp[0];
                    int maxf = ap_maxf[0];
                    if (maxf == 0) {
                        throw RError.getFFTFactorization(this.ast);
                    }
                    if (maxf > maxmaxf) {
                        maxmaxf = maxf;
                    }
                    if (maxp <= maxmaxp) continue;
                    maxmaxp = maxp;
                }
                double[] ap_work = new double[4 * maxmaxf];
                int[] ap_iwork = new int[maxmaxp];
                int nseg = res.size();
                int n = 1;
                int nspn = 1;
                for (int i = 0; i < ndims; ++i) {
                    int d = dims[i];
                    if (d <= 1) continue;
                    n = d;
                    GNUR.fft_factor(d, ap_maxf, ap_maxp);
                    GNUR.fft_work(z, nseg /= n, n, nspn *= n, ap_inv, ap_work, ap_iwork);
                }
                return res;
            }
        };
    }
}

