/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.RContext;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RInt;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.Connection;
import r.data.internal.ConnectionMode;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class File
extends CallFactory {
    static final CallFactory _ = new File("file", new String[]{"description", "open", "blocking", "encoding", "raw"}, new String[0]);
    static final ConnectionMode defaultMode = ConnectionMode.get("rt");
    private static final OpenConnection OPEN_FILE = new OpenConnection(){

        @Override
        public Connection createUnopened(String description, ConnectionMode defaultMode) {
            return Connection.FileConnection.createUnopened(description, defaultMode);
        }

        @Override
        public Connection createOpened(String description, ConnectionMode mode, ASTNode ast) {
            return Connection.FileConnection.createOpened(description, mode, ast);
        }
    };

    private File(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        if (ia.provided("blocking") || ia.provided("encoding") || ia.provided("raw")) {
            throw Utils.nyi();
        }
        final int posDescription = ia.position("description");
        final int posOpen = ia.position("open");
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                String description = posDescription != -1 ? File.getScalarString(args[posDescription], this.ast, "description") : "";
                String open = posOpen != -1 ? File.getScalarString(args[posOpen], this.ast, "open") : "";
                return OPEN_FILE.open(description, open, this.ast);
            }
        };
    }

    public static String getScalarString(RAny arg, ASTNode ast, String argName) {
        if (!(arg instanceof RString)) {
            throw RError.getInvalidArgument(ast, argName);
        }
        RString s = (RString)arg;
        if (s.size() == 1) {
            return s.getString(0);
        }
        throw RError.getInvalidArgument(ast, argName);
    }

    public static abstract class OpenConnection {
        public abstract Connection createUnopened(String var1, ConnectionMode var2);

        public abstract Connection createOpened(String var1, ConnectionMode var2, ASTNode var3);

        public RInt open(String description, String open, ASTNode ast) {
            if (description.length() == 0) {
                throw Utils.nyi("temporary file");
            }
            Connection con = null;
            if (open.length() == 0) {
                con = this.createUnopened(description, defaultMode);
            } else {
                ConnectionMode mode = ConnectionMode.get(open);
                if (mode == null) {
                    throw RError.getInvalidArgument(ast, "open");
                }
                con = this.createOpened(description, mode, ast);
            }
            int handle = RContext.allocateConnection(con);
            if (handle != -1) {
                return RInt.RIntFactory.getScalar(handle);
            }
            throw RError.getAllConnectionsInUse(ast);
        }
    }
}

