/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.builtins.AsBase;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.builtins.Paste;
import r.data.RAny;
import r.data.RString;
import r.data.RSymbol;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

public class FilePath
extends CallFactory {
    static final CallFactory _ = new FilePath("file.path", new String[]{"...", "fsep"}, new String[0]);

    private FilePath(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int posFsep = ia.position("fsep");
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                int nStringArgs;
                String sep;
                if (posFsep == -1) {
                    sep = "/";
                    nStringArgs = args.length;
                } else {
                    sep = Paste.parseSeparator(this.ast, args[posFsep]);
                    nStringArgs = args.length - 1;
                }
                RString[] stringArgs = new RString[nStringArgs];
                int j = 0;
                int maxLength = 0;
                for (int i = 0; i < args.length; ++i) {
                    if (i == posFsep) continue;
                    RString s = AsBase.genericAsString(this.ast, args[i]);
                    stringArgs[j++] = s;
                    int ssize = s.size();
                    if (ssize <= maxLength) continue;
                    maxLength = ssize;
                }
                String[] content = new String[maxLength];
                for (int i = 0; i < maxLength; ++i) {
                    StringBuilder str = new StringBuilder();
                    for (j = 0; j < nStringArgs; ++j) {
                        if (j > 0) {
                            str.append(sep);
                        }
                        RString s = stringArgs[j];
                        str.append(s.getString(i % s.size()));
                    }
                    content[i] = str.toString();
                }
                return RString.RStringFactory.getFor(content);
            }
        };
    }
}

