/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RList;
import r.data.RLogical;
import r.data.RNull;
import r.data.RRaw;
import r.data.RString;
import r.data.RSymbol;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

public class Identical
extends CallFactory {
    static final CallFactory _ = new Identical("identical", new String[]{"x", "y", "num.eq", "single.NA", "attrib.as.set", "ignore.bytecode"}, new String[]{"x", "y"});

    private Identical(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int posX = ia.position("x");
        final int posY = ia.position("y");
        int posNumEq = ia.position("num.eq");
        int posSingleNA = ia.position("single.NA");
        int posAttribAsSet = ia.position("attrib.as.set");
        int posIgnoreBytecode = ia.position("ignore.bytecode");
        if (posNumEq != -1 || posSingleNA != -1 || posAttribAsSet != -1 || posIgnoreBytecode != -1) {
            Utils.nyi("Unsupported option");
            return null;
        }
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                RAny xArg = args[posX];
                RAny yArg = args[posY];
                return Identical.identical(xArg, yArg) ? RLogical.BOXED_TRUE : RLogical.BOXED_FALSE;
            }
        };
    }

    public static boolean identical(RAny x, RAny y) {
        if (x == y) {
            return true;
        }
        boolean xArray = x instanceof RArray;
        boolean yArray = y instanceof RArray;
        if (xArray != yArray) {
            return false;
        }
        if (xArray) {
            if (!Identical.identicalDimensions((RArray)x, (RArray)y)) {
                return false;
            }
            if (!Identical.identicalNames((RArray)x, (RArray)y)) {
                return false;
            }
        }
        if (!Identical.identicalAttributes(x, y)) {
            return false;
        }
        if (x instanceof RList) {
            if (y instanceof RList) {
                return Identical.identical((RList)x, (RList)y);
            }
            return false;
        }
        if (x instanceof RString) {
            if (y instanceof RString) {
                return Identical.identical((RString)x, (RString)y);
            }
            return false;
        }
        if (x instanceof RComplex) {
            if (y instanceof RComplex) {
                return Identical.identical((RComplex)x, (RComplex)y);
            }
            return false;
        }
        if (x instanceof RDouble) {
            if (y instanceof RDouble) {
                return Identical.identical((RDouble)x, (RDouble)y);
            }
            return false;
        }
        if (x instanceof RInt) {
            if (y instanceof RInt) {
                return Identical.identical((RInt)x, (RInt)y);
            }
            return false;
        }
        if (x instanceof RLogical) {
            if (y instanceof RLogical) {
                return Identical.identical((RLogical)x, (RLogical)y);
            }
            return false;
        }
        if (x instanceof RRaw) {
            if (y instanceof RRaw) {
                return Identical.identical((RRaw)x, (RRaw)y);
            }
            return false;
        }
        if (x instanceof RNull) {
            return y instanceof RNull;
        }
        Utils.nyi("unsupported type");
        return false;
    }

    public static boolean identicalDimensions(RArray x, RArray y) {
        return Arrays.equals(x.dimensions(), y.dimensions());
    }

    public static boolean identicalNames(RArray x, RArray y) {
        RSymbol[] ynames;
        RSymbol[] xnames = x.names() == null ? null : x.names().sequence();
        RSymbol[] rSymbolArray = ynames = y.names() == null ? null : y.names().sequence();
        if (xnames == ynames) {
            return true;
        }
        if (xnames == null || ynames == null) {
            return false;
        }
        int len = xnames.length;
        if (len != ynames.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (xnames[i] == ynames[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean identicalAttributes(RAny x, RAny y) {
        RAny.Attributes yattr;
        RAny.Attributes xattr = x.attributes();
        if (xattr == (yattr = y.attributes())) {
            return true;
        }
        if (xattr == null) {
            return yattr.map().size() == 0;
        }
        if (yattr == null) {
            return xattr.map().size() == 0;
        }
        LinkedHashMap<RSymbol, RAny> xmap = xattr.map();
        LinkedHashMap<RSymbol, RAny> ymap = yattr.map();
        if (xmap.size() != ymap.size()) {
            return false;
        }
        for (Map.Entry<RSymbol, RAny> xentry : xmap.entrySet()) {
            RSymbol symbol = xentry.getKey();
            RAny xvalue = xentry.getValue();
            RAny yvalue = ymap.get(symbol);
            if (yvalue != null && Identical.identical(xvalue, yvalue)) continue;
            return false;
        }
        return true;
    }

    public static boolean identical(RRaw x, RRaw y) {
        int len = x.size();
        if (len != y.size()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (x.getRaw(i) == y.getRaw(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean identical(RLogical x, RLogical y) {
        int len = x.size();
        if (len != y.size()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (x.getLogical(i) == y.getLogical(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean identical(RInt x, RInt y) {
        int len = x.size();
        if (len != y.size()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (x.getInt(i) == y.getInt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean identical(RDouble x, RDouble y) {
        int len = x.size();
        if (len != y.size()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            double yd;
            double xd = x.getDouble(i);
            if (Identical.identical(xd, yd = y.getDouble(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean identical(RComplex x, RComplex y) {
        int len = x.size();
        if (len != y.size()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            double xr = x.getReal(i);
            double yr = y.getReal(i);
            double xi = x.getImag(i);
            double yi = y.getImag(i);
            if (Identical.identical(xr, yr) && Identical.identical(xi, yi)) continue;
            return false;
        }
        return true;
    }

    public static boolean identical(double x, double y) {
        boolean yIsNA;
        boolean xIsNAorNaN = RDouble.RDoubleUtils.isNAorNaN(x);
        boolean yIsNAorNaN = RDouble.RDoubleUtils.isNAorNaN(y);
        if (!xIsNAorNaN && !yIsNAorNaN) {
            return x == y;
        }
        if (xIsNAorNaN != yIsNAorNaN) {
            return false;
        }
        boolean xIsNA = RDouble.RDoubleUtils.isNA(x);
        return xIsNA == (yIsNA = RDouble.RDoubleUtils.isNA(y));
    }

    public static boolean identical(RString x, RString y) {
        int len = x.size();
        if (len != y.size()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            String ys;
            String xs = x.getString(i);
            if (xs == (ys = y.getString(i))) continue;
            if (xs == RString.NA || ys == RString.NA) {
                return false;
            }
            if (xs.compareTo(ys) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean identical(RList x, RList y) {
        int len = x.size();
        if (len != y.size()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            RAny ya;
            RAny xa = x.getRAny(i);
            if (Identical.identical(xa, ya = y.getRAny(i))) continue;
            return false;
        }
        return true;
    }
}

